package zio.aws.machinelearning.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.machinelearning.model.primitives.{
  RedshiftSelectSqlQuery,
  RedshiftDatabaseUsername
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RedshiftMetadata(
    redshiftDatabase: Optional[zio.aws.machinelearning.model.RedshiftDatabase] =
      Optional.Absent,
    databaseUserName: Optional[RedshiftDatabaseUsername] = Optional.Absent,
    selectSqlQuery: Optional[RedshiftSelectSqlQuery] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.machinelearning.model.RedshiftMetadata = {
    import RedshiftMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.machinelearning.model.RedshiftMetadata
      .builder()
      .optionallyWith(redshiftDatabase.map(value => value.buildAwsValue()))(
        _.redshiftDatabase
      )
      .optionallyWith(
        databaseUserName.map(value =>
          RedshiftDatabaseUsername.unwrap(value): java.lang.String
        )
      )(_.databaseUserName)
      .optionallyWith(
        selectSqlQuery.map(value =>
          RedshiftSelectSqlQuery.unwrap(value): java.lang.String
        )
      )(_.selectSqlQuery)
      .build()
  }
  def asReadOnly: zio.aws.machinelearning.model.RedshiftMetadata.ReadOnly =
    zio.aws.machinelearning.model.RedshiftMetadata.wrap(buildAwsValue())
}
object RedshiftMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.machinelearning.model.RedshiftMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.machinelearning.model.RedshiftMetadata =
      zio.aws.machinelearning.model.RedshiftMetadata(
        redshiftDatabase.map(value => value.asEditable),
        databaseUserName.map(value => value),
        selectSqlQuery.map(value => value)
      )
    def redshiftDatabase
        : Optional[zio.aws.machinelearning.model.RedshiftDatabase.ReadOnly]
    def databaseUserName: Optional[RedshiftDatabaseUsername]
    def selectSqlQuery: Optional[RedshiftSelectSqlQuery]
    def getRedshiftDatabase: ZIO[
      Any,
      AwsError,
      zio.aws.machinelearning.model.RedshiftDatabase.ReadOnly
    ] = AwsError.unwrapOptionField("redshiftDatabase", redshiftDatabase)
    def getDatabaseUserName: ZIO[Any, AwsError, RedshiftDatabaseUsername] =
      AwsError.unwrapOptionField("databaseUserName", databaseUserName)
    def getSelectSqlQuery: ZIO[Any, AwsError, RedshiftSelectSqlQuery] =
      AwsError.unwrapOptionField("selectSqlQuery", selectSqlQuery)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.machinelearning.model.RedshiftMetadata
  ) extends zio.aws.machinelearning.model.RedshiftMetadata.ReadOnly {
    override val redshiftDatabase
        : Optional[zio.aws.machinelearning.model.RedshiftDatabase.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.redshiftDatabase())
        .map(value =>
          zio.aws.machinelearning.model.RedshiftDatabase.wrap(value)
        )
    override val databaseUserName: Optional[RedshiftDatabaseUsername] =
      zio.aws.core.internal
        .optionalFromNullable(impl.databaseUserName())
        .map(value =>
          zio.aws.machinelearning.model.primitives
            .RedshiftDatabaseUsername(value)
        )
    override val selectSqlQuery: Optional[RedshiftSelectSqlQuery] =
      zio.aws.core.internal
        .optionalFromNullable(impl.selectSqlQuery())
        .map(value =>
          zio.aws.machinelearning.model.primitives.RedshiftSelectSqlQuery(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.machinelearning.model.RedshiftMetadata
  ): zio.aws.machinelearning.model.RedshiftMetadata.ReadOnly = new Wrapper(impl)
}
