package zio.aws.machinelearning.model
import zio.prelude.data.Optional
import zio.aws.machinelearning.model.primitives.{
  PageLimit,
  StringType,
  ComparatorValue
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeMlModelsRequest(
    filterVariable: Optional[
      zio.aws.machinelearning.model.MLModelFilterVariable
    ] = Optional.Absent,
    eq: Optional[ComparatorValue] = Optional.Absent,
    gt: Optional[ComparatorValue] = Optional.Absent,
    lt: Optional[ComparatorValue] = Optional.Absent,
    ge: Optional[ComparatorValue] = Optional.Absent,
    le: Optional[ComparatorValue] = Optional.Absent,
    ne: Optional[ComparatorValue] = Optional.Absent,
    prefix: Optional[ComparatorValue] = Optional.Absent,
    sortOrder: Optional[zio.aws.machinelearning.model.SortOrder] =
      Optional.Absent,
    nextToken: Optional[StringType] = Optional.Absent,
    limit: Optional[PageLimit] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.machinelearning.model.DescribeMlModelsRequest = {
    import DescribeMlModelsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.machinelearning.model.DescribeMlModelsRequest
      .builder()
      .optionallyWith(filterVariable.map(value => value.unwrap))(
        _.filterVariable
      )
      .optionallyWith(
        eq.map(value => ComparatorValue.unwrap(value): java.lang.String)
      )(_.eq)
      .optionallyWith(
        gt.map(value => ComparatorValue.unwrap(value): java.lang.String)
      )(_.gt)
      .optionallyWith(
        lt.map(value => ComparatorValue.unwrap(value): java.lang.String)
      )(_.lt)
      .optionallyWith(
        ge.map(value => ComparatorValue.unwrap(value): java.lang.String)
      )(_.ge)
      .optionallyWith(
        le.map(value => ComparatorValue.unwrap(value): java.lang.String)
      )(_.le)
      .optionallyWith(
        ne.map(value => ComparatorValue.unwrap(value): java.lang.String)
      )(_.ne)
      .optionallyWith(
        prefix.map(value => ComparatorValue.unwrap(value): java.lang.String)
      )(_.prefix)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(limit.map(value => PageLimit.unwrap(value): Integer))(
        _.limit
      )
      .build()
  }
  def asReadOnly
      : zio.aws.machinelearning.model.DescribeMlModelsRequest.ReadOnly =
    zio.aws.machinelearning.model.DescribeMlModelsRequest.wrap(buildAwsValue())
}
object DescribeMlModelsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.machinelearning.model.DescribeMlModelsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.machinelearning.model.DescribeMlModelsRequest =
      zio.aws.machinelearning.model.DescribeMlModelsRequest(
        filterVariable.map(value => value),
        eq.map(value => value),
        gt.map(value => value),
        lt.map(value => value),
        ge.map(value => value),
        le.map(value => value),
        ne.map(value => value),
        prefix.map(value => value),
        sortOrder.map(value => value),
        nextToken.map(value => value),
        limit.map(value => value)
      )
    def filterVariable
        : Optional[zio.aws.machinelearning.model.MLModelFilterVariable]
    def eq: Optional[ComparatorValue]
    def gt: Optional[ComparatorValue]
    def lt: Optional[ComparatorValue]
    def ge: Optional[ComparatorValue]
    def le: Optional[ComparatorValue]
    def ne: Optional[ComparatorValue]
    def prefix: Optional[ComparatorValue]
    def sortOrder: Optional[zio.aws.machinelearning.model.SortOrder]
    def nextToken: Optional[StringType]
    def limit: Optional[PageLimit]
    def getFilterVariable: ZIO[
      Any,
      AwsError,
      zio.aws.machinelearning.model.MLModelFilterVariable
    ] = AwsError.unwrapOptionField("filterVariable", filterVariable)
    def getEq: ZIO[Any, AwsError, ComparatorValue] =
      AwsError.unwrapOptionField("eq", eq)
    def getGt: ZIO[Any, AwsError, ComparatorValue] =
      AwsError.unwrapOptionField("gt", gt)
    def getLt: ZIO[Any, AwsError, ComparatorValue] =
      AwsError.unwrapOptionField("lt", lt)
    def getGe: ZIO[Any, AwsError, ComparatorValue] =
      AwsError.unwrapOptionField("ge", ge)
    def getLe: ZIO[Any, AwsError, ComparatorValue] =
      AwsError.unwrapOptionField("le", le)
    def getNe: ZIO[Any, AwsError, ComparatorValue] =
      AwsError.unwrapOptionField("ne", ne)
    def getPrefix: ZIO[Any, AwsError, ComparatorValue] =
      AwsError.unwrapOptionField("prefix", prefix)
    def getSortOrder
        : ZIO[Any, AwsError, zio.aws.machinelearning.model.SortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
    def getNextToken: ZIO[Any, AwsError, StringType] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getLimit: ZIO[Any, AwsError, PageLimit] =
      AwsError.unwrapOptionField("limit", limit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.machinelearning.model.DescribeMlModelsRequest
  ) extends zio.aws.machinelearning.model.DescribeMlModelsRequest.ReadOnly {
    override val filterVariable
        : Optional[zio.aws.machinelearning.model.MLModelFilterVariable] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filterVariable())
        .map(value =>
          zio.aws.machinelearning.model.MLModelFilterVariable.wrap(value)
        )
    override val eq: Optional[ComparatorValue] = zio.aws.core.internal
      .optionalFromNullable(impl.eq())
      .map(value =>
        zio.aws.machinelearning.model.primitives.ComparatorValue(value)
      )
    override val gt: Optional[ComparatorValue] = zio.aws.core.internal
      .optionalFromNullable(impl.gt())
      .map(value =>
        zio.aws.machinelearning.model.primitives.ComparatorValue(value)
      )
    override val lt: Optional[ComparatorValue] = zio.aws.core.internal
      .optionalFromNullable(impl.lt())
      .map(value =>
        zio.aws.machinelearning.model.primitives.ComparatorValue(value)
      )
    override val ge: Optional[ComparatorValue] = zio.aws.core.internal
      .optionalFromNullable(impl.ge())
      .map(value =>
        zio.aws.machinelearning.model.primitives.ComparatorValue(value)
      )
    override val le: Optional[ComparatorValue] = zio.aws.core.internal
      .optionalFromNullable(impl.le())
      .map(value =>
        zio.aws.machinelearning.model.primitives.ComparatorValue(value)
      )
    override val ne: Optional[ComparatorValue] = zio.aws.core.internal
      .optionalFromNullable(impl.ne())
      .map(value =>
        zio.aws.machinelearning.model.primitives.ComparatorValue(value)
      )
    override val prefix: Optional[ComparatorValue] = zio.aws.core.internal
      .optionalFromNullable(impl.prefix())
      .map(value =>
        zio.aws.machinelearning.model.primitives.ComparatorValue(value)
      )
    override val sortOrder: Optional[zio.aws.machinelearning.model.SortOrder] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortOrder())
        .map(value => zio.aws.machinelearning.model.SortOrder.wrap(value))
    override val nextToken: Optional[StringType] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: StringType)
    override val limit: Optional[PageLimit] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value => zio.aws.machinelearning.model.primitives.PageLimit(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.machinelearning.model.DescribeMlModelsRequest
  ): zio.aws.machinelearning.model.DescribeMlModelsRequest.ReadOnly =
    new Wrapper(impl)
}
