package zio.aws.machinelearning.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.machinelearning.model.primitives.EntityId
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateEvaluationResponse(
    evaluationId: Optional[EntityId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.machinelearning.model.UpdateEvaluationResponse = {
    import UpdateEvaluationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.machinelearning.model.UpdateEvaluationResponse
      .builder()
      .optionallyWith(
        evaluationId.map(value => EntityId.unwrap(value): java.lang.String)
      )(_.evaluationId)
      .build()
  }
  def asReadOnly
      : zio.aws.machinelearning.model.UpdateEvaluationResponse.ReadOnly =
    zio.aws.machinelearning.model.UpdateEvaluationResponse.wrap(buildAwsValue())
}
object UpdateEvaluationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.machinelearning.model.UpdateEvaluationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.machinelearning.model.UpdateEvaluationResponse =
      zio.aws.machinelearning.model
        .UpdateEvaluationResponse(evaluationId.map(value => value))
    def evaluationId: Optional[EntityId]
    def getEvaluationId: ZIO[Any, AwsError, EntityId] =
      AwsError.unwrapOptionField("evaluationId", evaluationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.machinelearning.model.UpdateEvaluationResponse
  ) extends zio.aws.machinelearning.model.UpdateEvaluationResponse.ReadOnly {
    override val evaluationId: Optional[EntityId] = zio.aws.core.internal
      .optionalFromNullable(impl.evaluationId())
      .map(value => zio.aws.machinelearning.model.primitives.EntityId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.machinelearning.model.UpdateEvaluationResponse
  ): zio.aws.machinelearning.model.UpdateEvaluationResponse.ReadOnly =
    new Wrapper(impl)
}
