package zio.aws.machinelearning.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.machinelearning.model.primitives.EntityId
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateRealtimeEndpointResponse(
    mlModelId: Optional[EntityId] = Optional.Absent,
    realtimeEndpointInfo: Optional[
      zio.aws.machinelearning.model.RealtimeEndpointInfo
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.machinelearning.model.CreateRealtimeEndpointResponse = {
    import CreateRealtimeEndpointResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.machinelearning.model.CreateRealtimeEndpointResponse
      .builder()
      .optionallyWith(
        mlModelId.map(value => EntityId.unwrap(value): java.lang.String)
      )(_.mlModelId)
      .optionallyWith(realtimeEndpointInfo.map(value => value.buildAwsValue()))(
        _.realtimeEndpointInfo
      )
      .build()
  }
  def asReadOnly
      : zio.aws.machinelearning.model.CreateRealtimeEndpointResponse.ReadOnly =
    zio.aws.machinelearning.model.CreateRealtimeEndpointResponse
      .wrap(buildAwsValue())
}
object CreateRealtimeEndpointResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.machinelearning.model.CreateRealtimeEndpointResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.machinelearning.model.CreateRealtimeEndpointResponse =
      zio.aws.machinelearning.model.CreateRealtimeEndpointResponse(
        mlModelId.map(value => value),
        realtimeEndpointInfo.map(value => value.asEditable)
      )
    def mlModelId: Optional[EntityId]
    def realtimeEndpointInfo
        : Optional[zio.aws.machinelearning.model.RealtimeEndpointInfo.ReadOnly]
    def getMlModelId: ZIO[Any, AwsError, EntityId] =
      AwsError.unwrapOptionField("mlModelId", mlModelId)
    def getRealtimeEndpointInfo: ZIO[
      Any,
      AwsError,
      zio.aws.machinelearning.model.RealtimeEndpointInfo.ReadOnly
    ] = AwsError.unwrapOptionField("realtimeEndpointInfo", realtimeEndpointInfo)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.machinelearning.model.CreateRealtimeEndpointResponse
  ) extends zio.aws.machinelearning.model.CreateRealtimeEndpointResponse.ReadOnly {
    override val mlModelId: Optional[EntityId] = zio.aws.core.internal
      .optionalFromNullable(impl.mlModelId())
      .map(value => zio.aws.machinelearning.model.primitives.EntityId(value))
    override val realtimeEndpointInfo: Optional[
      zio.aws.machinelearning.model.RealtimeEndpointInfo.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.realtimeEndpointInfo())
      .map(value =>
        zio.aws.machinelearning.model.RealtimeEndpointInfo.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.machinelearning.model.CreateRealtimeEndpointResponse
  ): zio.aws.machinelearning.model.CreateRealtimeEndpointResponse.ReadOnly =
    new Wrapper(impl)
}
