package zio.aws.machinelearning.model
import scala.jdk.CollectionConverters.*
sealed trait DetailsAttributes {
  def unwrap
      : software.amazon.awssdk.services.machinelearning.model.DetailsAttributes
}
object DetailsAttributes {
  def wrap(
      value: software.amazon.awssdk.services.machinelearning.model.DetailsAttributes
  ): zio.aws.machinelearning.model.DetailsAttributes = value match {
    case software.amazon.awssdk.services.machinelearning.model.DetailsAttributes.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.machinelearning.model.DetailsAttributes.PREDICTIVE_MODEL_TYPE =>
      val r = PredictiveModelType
      r
    case software.amazon.awssdk.services.machinelearning.model.DetailsAttributes.ALGORITHM =>
      val r = Algorithm
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.machinelearning.model.DetailsAttributes {
    override def unwrap
        : software.amazon.awssdk.services.machinelearning.model.DetailsAttributes =
      software.amazon.awssdk.services.machinelearning.model.DetailsAttributes.UNKNOWN_TO_SDK_VERSION
  }
  case object PredictiveModelType
      extends zio.aws.machinelearning.model.DetailsAttributes {
    override def unwrap
        : software.amazon.awssdk.services.machinelearning.model.DetailsAttributes =
      software.amazon.awssdk.services.machinelearning.model.DetailsAttributes.PREDICTIVE_MODEL_TYPE
  }
  case object Algorithm
      extends zio.aws.machinelearning.model.DetailsAttributes {
    override def unwrap
        : software.amazon.awssdk.services.machinelearning.model.DetailsAttributes =
      software.amazon.awssdk.services.machinelearning.model.DetailsAttributes.ALGORITHM
  }
}
