package zio.aws.machinelearning.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.machinelearning.model.primitives.{
  ScoreThreshold,
  EntityName,
  EntityId
}
import scala.jdk.CollectionConverters.*
final case class UpdateMlModelRequest(
    mlModelId: EntityId,
    mlModelName: Option[EntityName] = None,
    scoreThreshold: Option[ScoreThreshold] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.machinelearning.model.UpdateMlModelRequest = {
    import UpdateMlModelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.machinelearning.model.UpdateMlModelRequest
      .builder()
      .mlModelId(EntityId.unwrap(mlModelId): java.lang.String)
      .optionallyWith(
        mlModelName.map(value => EntityName.unwrap(value): java.lang.String)
      )(_.mlModelName)
      .optionallyWith(
        scoreThreshold.map(value =>
          ScoreThreshold.unwrap(value): java.lang.Float
        )
      )(_.scoreThreshold)
      .build()
  }
  def asReadOnly: zio.aws.machinelearning.model.UpdateMlModelRequest.ReadOnly =
    zio.aws.machinelearning.model.UpdateMlModelRequest.wrap(buildAwsValue())
}
object UpdateMlModelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.machinelearning.model.UpdateMlModelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.machinelearning.model.UpdateMlModelRequest =
      zio.aws.machinelearning.model.UpdateMlModelRequest(
        mlModelId,
        mlModelName.map(value => value),
        scoreThreshold.map(value => value)
      )
    def mlModelId: EntityId
    def mlModelName: Option[EntityName]
    def scoreThreshold: Option[ScoreThreshold]
    def getMlModelId: ZIO[Any, Nothing, EntityId] = ZIO.succeed(mlModelId)
    def getMlModelName: ZIO[Any, AwsError, EntityName] =
      AwsError.unwrapOptionField("mlModelName", mlModelName)
    def getScoreThreshold: ZIO[Any, AwsError, ScoreThreshold] =
      AwsError.unwrapOptionField("scoreThreshold", scoreThreshold)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.machinelearning.model.UpdateMlModelRequest
  ) extends zio.aws.machinelearning.model.UpdateMlModelRequest.ReadOnly {
    override val mlModelId: EntityId =
      zio.aws.machinelearning.model.primitives.EntityId(impl.mlModelId())
    override val mlModelName: Option[EntityName] = scala
      .Option(impl.mlModelName())
      .map(value => zio.aws.machinelearning.model.primitives.EntityName(value))
    override val scoreThreshold: Option[ScoreThreshold] = scala
      .Option(impl.scoreThreshold())
      .map(value =>
        zio.aws.machinelearning.model.primitives.ScoreThreshold(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.machinelearning.model.UpdateMlModelRequest
  ): zio.aws.machinelearning.model.UpdateMlModelRequest.ReadOnly = new Wrapper(
    impl
  )
}
