package zio.aws.machinelearning.model
import java.time.Instant
import zio.aws.machinelearning.model.primitives.{VipURL, EpochTime, IntegerType}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class RealtimeEndpointInfo(
    peakRequestsPerSecond: Option[IntegerType] = None,
    createdAt: Option[EpochTime] = None,
    endpointUrl: Option[VipURL] = None,
    endpointStatus: Option[
      zio.aws.machinelearning.model.RealtimeEndpointStatus
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.machinelearning.model.RealtimeEndpointInfo = {
    import RealtimeEndpointInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.machinelearning.model.RealtimeEndpointInfo
      .builder()
      .optionallyWith(
        peakRequestsPerSecond.map(value => IntegerType.unwrap(value): Integer)
      )(_.peakRequestsPerSecond)
      .optionallyWith(createdAt.map(value => EpochTime.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        endpointUrl.map(value => VipURL.unwrap(value): java.lang.String)
      )(_.endpointUrl)
      .optionallyWith(endpointStatus.map(value => value.unwrap))(
        _.endpointStatus
      )
      .build()
  }
  def asReadOnly: zio.aws.machinelearning.model.RealtimeEndpointInfo.ReadOnly =
    zio.aws.machinelearning.model.RealtimeEndpointInfo.wrap(buildAwsValue())
}
object RealtimeEndpointInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.machinelearning.model.RealtimeEndpointInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.machinelearning.model.RealtimeEndpointInfo =
      zio.aws.machinelearning.model.RealtimeEndpointInfo(
        peakRequestsPerSecond.map(value => value),
        createdAt.map(value => value),
        endpointUrl.map(value => value),
        endpointStatus.map(value => value)
      )
    def peakRequestsPerSecond: Option[IntegerType]
    def createdAt: Option[EpochTime]
    def endpointUrl: Option[VipURL]
    def endpointStatus
        : Option[zio.aws.machinelearning.model.RealtimeEndpointStatus]
    def getPeakRequestsPerSecond: ZIO[Any, AwsError, IntegerType] =
      AwsError.unwrapOptionField("peakRequestsPerSecond", peakRequestsPerSecond)
    def getCreatedAt: ZIO[Any, AwsError, EpochTime] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getEndpointUrl: ZIO[Any, AwsError, VipURL] =
      AwsError.unwrapOptionField("endpointUrl", endpointUrl)
    def getEndpointStatus: ZIO[
      Any,
      AwsError,
      zio.aws.machinelearning.model.RealtimeEndpointStatus
    ] = AwsError.unwrapOptionField("endpointStatus", endpointStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.machinelearning.model.RealtimeEndpointInfo
  ) extends zio.aws.machinelearning.model.RealtimeEndpointInfo.ReadOnly {
    override val peakRequestsPerSecond: Option[IntegerType] = scala
      .Option(impl.peakRequestsPerSecond())
      .map(value => zio.aws.machinelearning.model.primitives.IntegerType(value))
    override val createdAt: Option[EpochTime] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.machinelearning.model.primitives.EpochTime(value))
    override val endpointUrl: Option[VipURL] = scala
      .Option(impl.endpointUrl())
      .map(value => zio.aws.machinelearning.model.primitives.VipURL(value))
    override val endpointStatus
        : Option[zio.aws.machinelearning.model.RealtimeEndpointStatus] = scala
      .Option(impl.endpointStatus())
      .map(value =>
        zio.aws.machinelearning.model.RealtimeEndpointStatus.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.machinelearning.model.RealtimeEndpointInfo
  ): zio.aws.machinelearning.model.RealtimeEndpointInfo.ReadOnly = new Wrapper(
    impl
  )
}
