package zio.aws.machinelearning.model
import scala.jdk.CollectionConverters.*
sealed trait EntityStatus {
  def unwrap: software.amazon.awssdk.services.machinelearning.model.EntityStatus
}
object EntityStatus {
  def wrap(
      value: software.amazon.awssdk.services.machinelearning.model.EntityStatus
  ): zio.aws.machinelearning.model.EntityStatus = value match {
    case software.amazon.awssdk.services.machinelearning.model.EntityStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.machinelearning.model.EntityStatus.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.machinelearning.model.EntityStatus.INPROGRESS =>
      val r = INPROGRESS
      r
    case software.amazon.awssdk.services.machinelearning.model.EntityStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.machinelearning.model.EntityStatus.COMPLETED =>
      val r = COMPLETED
      r
    case software.amazon.awssdk.services.machinelearning.model.EntityStatus.DELETED =>
      val r = DELETED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.machinelearning.model.EntityStatus {
    override def unwrap
        : software.amazon.awssdk.services.machinelearning.model.EntityStatus =
      software.amazon.awssdk.services.machinelearning.model.EntityStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING extends zio.aws.machinelearning.model.EntityStatus {
    override def unwrap
        : software.amazon.awssdk.services.machinelearning.model.EntityStatus =
      software.amazon.awssdk.services.machinelearning.model.EntityStatus.PENDING
  }
  case object INPROGRESS extends zio.aws.machinelearning.model.EntityStatus {
    override def unwrap
        : software.amazon.awssdk.services.machinelearning.model.EntityStatus =
      software.amazon.awssdk.services.machinelearning.model.EntityStatus.INPROGRESS
  }
  case object FAILED extends zio.aws.machinelearning.model.EntityStatus {
    override def unwrap
        : software.amazon.awssdk.services.machinelearning.model.EntityStatus =
      software.amazon.awssdk.services.machinelearning.model.EntityStatus.FAILED
  }
  case object COMPLETED extends zio.aws.machinelearning.model.EntityStatus {
    override def unwrap
        : software.amazon.awssdk.services.machinelearning.model.EntityStatus =
      software.amazon.awssdk.services.machinelearning.model.EntityStatus.COMPLETED
  }
  case object DELETED extends zio.aws.machinelearning.model.EntityStatus {
    override def unwrap
        : software.amazon.awssdk.services.machinelearning.model.EntityStatus =
      software.amazon.awssdk.services.machinelearning.model.EntityStatus.DELETED
  }
}
