package zio.aws.machinelearning.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.machinelearning.model.primitives.{
  Recipe,
  S3Url,
  EntityId,
  EntityName,
  StringType
}
import scala.jdk.CollectionConverters.*
final case class CreateMlModelRequest(
    mlModelId: EntityId,
    mlModelName: Option[EntityName] = None,
    mlModelType: zio.aws.machinelearning.model.MLModelType,
    parameters: Option[Map[StringType, StringType]] = None,
    trainingDataSourceId: EntityId,
    recipe: Option[Recipe] = None,
    recipeUri: Option[S3Url] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.machinelearning.model.CreateMlModelRequest = {
    import CreateMlModelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.machinelearning.model.CreateMlModelRequest
      .builder()
      .mlModelId(EntityId.unwrap(mlModelId): java.lang.String)
      .optionallyWith(
        mlModelName.map(value => EntityName.unwrap(value): java.lang.String)
      )(_.mlModelName)
      .mlModelType(mlModelType.unwrap)
      .optionallyWith(
        parameters.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.parameters)
      .trainingDataSourceId(
        EntityId.unwrap(trainingDataSourceId): java.lang.String
      )
      .optionallyWith(
        recipe.map(value => Recipe.unwrap(value): java.lang.String)
      )(_.recipe)
      .optionallyWith(
        recipeUri.map(value => S3Url.unwrap(value): java.lang.String)
      )(_.recipeUri)
      .build()
  }
  def asReadOnly: zio.aws.machinelearning.model.CreateMlModelRequest.ReadOnly =
    zio.aws.machinelearning.model.CreateMlModelRequest.wrap(buildAwsValue())
}
object CreateMlModelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.machinelearning.model.CreateMlModelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.machinelearning.model.CreateMlModelRequest =
      zio.aws.machinelearning.model.CreateMlModelRequest(
        mlModelId,
        mlModelName.map(value => value),
        mlModelType,
        parameters.map(value => value),
        trainingDataSourceId,
        recipe.map(value => value),
        recipeUri.map(value => value)
      )
    def mlModelId: EntityId
    def mlModelName: Option[EntityName]
    def mlModelType: zio.aws.machinelearning.model.MLModelType
    def parameters: Option[Map[StringType, StringType]]
    def trainingDataSourceId: EntityId
    def recipe: Option[Recipe]
    def recipeUri: Option[S3Url]
    def getMlModelId: ZIO[Any, Nothing, EntityId] = ZIO.succeed(mlModelId)
    def getMlModelName: ZIO[Any, AwsError, EntityName] =
      AwsError.unwrapOptionField("mlModelName", mlModelName)
    def getMlModelType
        : ZIO[Any, Nothing, zio.aws.machinelearning.model.MLModelType] =
      ZIO.succeed(mlModelType)
    def getParameters: ZIO[Any, AwsError, Map[StringType, StringType]] =
      AwsError.unwrapOptionField("parameters", parameters)
    def getTrainingDataSourceId: ZIO[Any, Nothing, EntityId] =
      ZIO.succeed(trainingDataSourceId)
    def getRecipe: ZIO[Any, AwsError, Recipe] =
      AwsError.unwrapOptionField("recipe", recipe)
    def getRecipeUri: ZIO[Any, AwsError, S3Url] =
      AwsError.unwrapOptionField("recipeUri", recipeUri)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.machinelearning.model.CreateMlModelRequest
  ) extends zio.aws.machinelearning.model.CreateMlModelRequest.ReadOnly {
    override val mlModelId: EntityId =
      zio.aws.machinelearning.model.primitives.EntityId(impl.mlModelId())
    override val mlModelName: Option[EntityName] = scala
      .Option(impl.mlModelName())
      .map(value => zio.aws.machinelearning.model.primitives.EntityName(value))
    override val mlModelType: zio.aws.machinelearning.model.MLModelType =
      zio.aws.machinelearning.model.MLModelType.wrap(impl.mlModelType())
    override val parameters: Option[Map[StringType, StringType]] = scala
      .Option(impl.parameters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: StringType) -> (value: StringType)
          })
          .toMap
      )
    override val trainingDataSourceId: EntityId =
      zio.aws.machinelearning.model.primitives
        .EntityId(impl.trainingDataSourceId())
    override val recipe: Option[Recipe] = scala
      .Option(impl.recipe())
      .map(value => zio.aws.machinelearning.model.primitives.Recipe(value))
    override val recipeUri: Option[S3Url] = scala
      .Option(impl.recipeUri())
      .map(value => zio.aws.machinelearning.model.primitives.S3Url(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.machinelearning.model.CreateMlModelRequest
  ): zio.aws.machinelearning.model.CreateMlModelRequest.ReadOnly = new Wrapper(
    impl
  )
}
