package zio.aws.machinelearning
import zio.prelude.Subtype
import zio.aws.machinelearning.model.primitives.{
  DetailsValue,
  Label,
  PerformanceMetricsPropertyValue,
  EDPSecurityGroupId,
  ScoreValue,
  VariableName,
  PerformanceMetricsPropertyKey,
  VariableValue,
  StringType,
  TagKey
}
import java.time.Instant
import zio.aws.machinelearning.model.primitives.EDPServiceRole.Type
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    object AwsUserArn extends Subtype[String]
    type AwsUserArn = zio.aws.machinelearning.model.primitives.AwsUserArn.Type
    object ComparatorValue extends Subtype[String]
    type ComparatorValue =
      zio.aws.machinelearning.model.primitives.ComparatorValue.Type
    object ComputeStatistics extends Subtype[Boolean]
    type ComputeStatistics =
      zio.aws.machinelearning.model.primitives.ComputeStatistics.Type
    object DataRearrangement extends Subtype[String]
    type DataRearrangement =
      zio.aws.machinelearning.model.primitives.DataRearrangement.Type
    object DataSchema extends Subtype[String]
    type DataSchema = zio.aws.machinelearning.model.primitives.DataSchema.Type
    object DetailsValue extends Subtype[String]
    type DetailsValue =
      zio.aws.machinelearning.model.primitives.DetailsValue.Type
    object EDPPipelineId extends Subtype[String]
    type EDPPipelineId =
      zio.aws.machinelearning.model.primitives.EDPPipelineId.Type
    object EDPResourceRole extends Subtype[String]
    type EDPResourceRole =
      zio.aws.machinelearning.model.primitives.EDPResourceRole.Type
    object EDPSecurityGroupId extends Subtype[String]
    type EDPSecurityGroupId =
      zio.aws.machinelearning.model.primitives.EDPSecurityGroupId.Type
    object EDPServiceRole extends Subtype[String]
    type EDPServiceRole =
      zio.aws.machinelearning.model.primitives.EDPServiceRole.Type
    object EDPSubnetId extends Subtype[String]
    type EDPSubnetId = zio.aws.machinelearning.model.primitives.EDPSubnetId.Type
    object EntityId extends Subtype[String]
    type EntityId = zio.aws.machinelearning.model.primitives.EntityId.Type
    object EntityName extends Subtype[String]
    type EntityName = zio.aws.machinelearning.model.primitives.EntityName.Type
    object EpochTime extends Subtype[Instant]
    type EpochTime = zio.aws.machinelearning.model.primitives.EpochTime.Type
    object FloatLabel extends Subtype[Float]
    type FloatLabel = zio.aws.machinelearning.model.primitives.FloatLabel.Type
    object IntegerType extends Subtype[Int]
    type IntegerType = zio.aws.machinelearning.model.primitives.IntegerType.Type
    object Label extends Subtype[String]
    type Label = zio.aws.machinelearning.model.primitives.Label.Type
    object LongType extends Subtype[Long]
    type LongType = zio.aws.machinelearning.model.primitives.LongType.Type
    object MLModelName extends Subtype[String]
    type MLModelName = zio.aws.machinelearning.model.primitives.MLModelName.Type
    object Message extends Subtype[String]
    type Message = zio.aws.machinelearning.model.primitives.Message.Type
    object PageLimit extends Subtype[Int]
    type PageLimit = zio.aws.machinelearning.model.primitives.PageLimit.Type
    object PerformanceMetricsPropertyKey extends Subtype[String]
    type PerformanceMetricsPropertyKey =
      zio.aws.machinelearning.model.primitives.PerformanceMetricsPropertyKey.Type
    object PerformanceMetricsPropertyValue extends Subtype[String]
    type PerformanceMetricsPropertyValue =
      zio.aws.machinelearning.model.primitives.PerformanceMetricsPropertyValue.Type
    object PresignedS3Url extends Subtype[String]
    type PresignedS3Url =
      zio.aws.machinelearning.model.primitives.PresignedS3Url.Type
    object RDSDatabaseName extends Subtype[String]
    type RDSDatabaseName =
      zio.aws.machinelearning.model.primitives.RDSDatabaseName.Type
    object RDSDatabasePassword extends Subtype[String]
    type RDSDatabasePassword =
      zio.aws.machinelearning.model.primitives.RDSDatabasePassword.Type
    object RDSDatabaseUsername extends Subtype[String]
    type RDSDatabaseUsername =
      zio.aws.machinelearning.model.primitives.RDSDatabaseUsername.Type
    object RDSInstanceIdentifier extends Subtype[String]
    type RDSInstanceIdentifier =
      zio.aws.machinelearning.model.primitives.RDSInstanceIdentifier.Type
    object RDSSelectSqlQuery extends Subtype[String]
    type RDSSelectSqlQuery =
      zio.aws.machinelearning.model.primitives.RDSSelectSqlQuery.Type
    object Recipe extends Subtype[String]
    type Recipe = zio.aws.machinelearning.model.primitives.Recipe.Type
    object RedshiftClusterIdentifier extends Subtype[String]
    type RedshiftClusterIdentifier =
      zio.aws.machinelearning.model.primitives.RedshiftClusterIdentifier.Type
    object RedshiftDatabaseName extends Subtype[String]
    type RedshiftDatabaseName =
      zio.aws.machinelearning.model.primitives.RedshiftDatabaseName.Type
    object RedshiftDatabasePassword extends Subtype[String]
    type RedshiftDatabasePassword =
      zio.aws.machinelearning.model.primitives.RedshiftDatabasePassword.Type
    object RedshiftDatabaseUsername extends Subtype[String]
    type RedshiftDatabaseUsername =
      zio.aws.machinelearning.model.primitives.RedshiftDatabaseUsername.Type
    object RedshiftSelectSqlQuery extends Subtype[String]
    type RedshiftSelectSqlQuery =
      zio.aws.machinelearning.model.primitives.RedshiftSelectSqlQuery.Type
    object RoleARN extends Subtype[String]
    type RoleARN = zio.aws.machinelearning.model.primitives.RoleARN.Type
    object S3Url extends Subtype[String]
    type S3Url = zio.aws.machinelearning.model.primitives.S3Url.Type
    object ScoreThreshold extends Subtype[Float]
    type ScoreThreshold =
      zio.aws.machinelearning.model.primitives.ScoreThreshold.Type
    object ScoreValue extends Subtype[Float]
    type ScoreValue = zio.aws.machinelearning.model.primitives.ScoreValue.Type
    object StringType extends Subtype[String]
    type StringType = zio.aws.machinelearning.model.primitives.StringType.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.machinelearning.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.machinelearning.model.primitives.TagValue.Type
    object VariableName extends Subtype[String]
    type VariableName =
      zio.aws.machinelearning.model.primitives.VariableName.Type
    object VariableValue extends Subtype[String]
    type VariableValue =
      zio.aws.machinelearning.model.primitives.VariableValue.Type
    object Verbose extends Subtype[Boolean]
    type Verbose = zio.aws.machinelearning.model.primitives.Verbose.Type
    object VipURL extends Subtype[String]
    type VipURL = zio.aws.machinelearning.model.primitives.VipURL.Type
  }
  type BatchPredictions = List[zio.aws.machinelearning.model.BatchPrediction]
  type DataSources = List[zio.aws.machinelearning.model.DataSource]
  type DetailsMap =
    Map[zio.aws.machinelearning.model.DetailsAttributes, DetailsValue]
  type EDPSecurityGroupIds = List[EDPSecurityGroupId]
  type Evaluations = List[zio.aws.machinelearning.model.Evaluation]
  type MLModels = List[zio.aws.machinelearning.model.MLModel]
  type PerformanceMetricsProperties =
    Map[PerformanceMetricsPropertyKey, PerformanceMetricsPropertyValue]
  type Record = Map[VariableName, VariableValue]
  type ScoreValuePerLabelMap = Map[Label, ScoreValue]
  type TagKeyList = List[TagKey]
  type TagList = List[zio.aws.machinelearning.model.Tag]
  type TrainingParameters = Map[StringType, StringType]
}
