package zio.aws.machinelearning.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.machinelearning.model.primitives.{
  Message,
  ScoreThreshold,
  S3Url,
  MLModelName,
  EpochTime,
  EntityId,
  LongType,
  AwsUserArn,
  StringType
}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class MLModel(
    mlModelId: Option[EntityId] = None,
    trainingDataSourceId: Option[EntityId] = None,
    createdByIamUser: Option[AwsUserArn] = None,
    createdAt: Option[EpochTime] = None,
    lastUpdatedAt: Option[EpochTime] = None,
    name: Option[MLModelName] = None,
    status: Option[zio.aws.machinelearning.model.EntityStatus] = None,
    sizeInBytes: Option[LongType] = None,
    endpointInfo: Option[zio.aws.machinelearning.model.RealtimeEndpointInfo] =
      None,
    trainingParameters: Option[Map[StringType, StringType]] = None,
    inputDataLocationS3: Option[S3Url] = None,
    algorithm: Option[zio.aws.machinelearning.model.Algorithm] = None,
    mlModelType: Option[zio.aws.machinelearning.model.MLModelType] = None,
    scoreThreshold: Option[ScoreThreshold] = None,
    scoreThresholdLastUpdatedAt: Option[EpochTime] = None,
    message: Option[Message] = None,
    computeTime: Option[LongType] = None,
    finishedAt: Option[EpochTime] = None,
    startedAt: Option[EpochTime] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.machinelearning.model.MLModel = {
    import MLModel.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.machinelearning.model.MLModel
      .builder()
      .optionallyWith(
        mlModelId.map(value => EntityId.unwrap(value): java.lang.String)
      )(_.mlModelId)
      .optionallyWith(
        trainingDataSourceId.map(value =>
          EntityId.unwrap(value): java.lang.String
        )
      )(_.trainingDataSourceId)
      .optionallyWith(
        createdByIamUser.map(value =>
          AwsUserArn.unwrap(value): java.lang.String
        )
      )(_.createdByIamUser)
      .optionallyWith(createdAt.map(value => EpochTime.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        lastUpdatedAt.map(value => EpochTime.unwrap(value): Instant)
      )(_.lastUpdatedAt)
      .optionallyWith(
        name.map(value => MLModelName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        sizeInBytes.map(value => LongType.unwrap(value): java.lang.Long)
      )(_.sizeInBytes)
      .optionallyWith(endpointInfo.map(value => value.buildAwsValue()))(
        _.endpointInfo
      )
      .optionallyWith(
        trainingParameters.map(value =>
          value
            .map({ case (key, value) =>
              (StringType.unwrap(key): java.lang.String) -> (StringType.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.trainingParameters)
      .optionallyWith(
        inputDataLocationS3.map(value => S3Url.unwrap(value): java.lang.String)
      )(_.inputDataLocationS3)
      .optionallyWith(algorithm.map(value => value.unwrap))(_.algorithm)
      .optionallyWith(mlModelType.map(value => value.unwrap))(_.mlModelType)
      .optionallyWith(
        scoreThreshold.map(value =>
          ScoreThreshold.unwrap(value): java.lang.Float
        )
      )(_.scoreThreshold)
      .optionallyWith(
        scoreThresholdLastUpdatedAt.map(value =>
          EpochTime.unwrap(value): Instant
        )
      )(_.scoreThresholdLastUpdatedAt)
      .optionallyWith(
        message.map(value => Message.unwrap(value): java.lang.String)
      )(_.message)
      .optionallyWith(
        computeTime.map(value => LongType.unwrap(value): java.lang.Long)
      )(_.computeTime)
      .optionallyWith(
        finishedAt.map(value => EpochTime.unwrap(value): Instant)
      )(_.finishedAt)
      .optionallyWith(startedAt.map(value => EpochTime.unwrap(value): Instant))(
        _.startedAt
      )
      .build()
  }
  def asReadOnly: zio.aws.machinelearning.model.MLModel.ReadOnly =
    zio.aws.machinelearning.model.MLModel.wrap(buildAwsValue())
}
object MLModel {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.machinelearning.model.MLModel
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.machinelearning.model.MLModel =
      zio.aws.machinelearning.model.MLModel(
        mlModelId.map(value => value),
        trainingDataSourceId.map(value => value),
        createdByIamUser.map(value => value),
        createdAt.map(value => value),
        lastUpdatedAt.map(value => value),
        name.map(value => value),
        status.map(value => value),
        sizeInBytes.map(value => value),
        endpointInfo.map(value => value.asEditable),
        trainingParameters.map(value => value),
        inputDataLocationS3.map(value => value),
        algorithm.map(value => value),
        mlModelType.map(value => value),
        scoreThreshold.map(value => value),
        scoreThresholdLastUpdatedAt.map(value => value),
        message.map(value => value),
        computeTime.map(value => value),
        finishedAt.map(value => value),
        startedAt.map(value => value)
      )
    def mlModelId: Option[EntityId]
    def trainingDataSourceId: Option[EntityId]
    def createdByIamUser: Option[AwsUserArn]
    def createdAt: Option[EpochTime]
    def lastUpdatedAt: Option[EpochTime]
    def name: Option[MLModelName]
    def status: Option[zio.aws.machinelearning.model.EntityStatus]
    def sizeInBytes: Option[LongType]
    def endpointInfo
        : Option[zio.aws.machinelearning.model.RealtimeEndpointInfo.ReadOnly]
    def trainingParameters: Option[Map[StringType, StringType]]
    def inputDataLocationS3: Option[S3Url]
    def algorithm: Option[zio.aws.machinelearning.model.Algorithm]
    def mlModelType: Option[zio.aws.machinelearning.model.MLModelType]
    def scoreThreshold: Option[ScoreThreshold]
    def scoreThresholdLastUpdatedAt: Option[EpochTime]
    def message: Option[Message]
    def computeTime: Option[LongType]
    def finishedAt: Option[EpochTime]
    def startedAt: Option[EpochTime]
    def getMlModelId: ZIO[Any, AwsError, EntityId] =
      AwsError.unwrapOptionField("mlModelId", mlModelId)
    def getTrainingDataSourceId: ZIO[Any, AwsError, EntityId] =
      AwsError.unwrapOptionField("trainingDataSourceId", trainingDataSourceId)
    def getCreatedByIamUser: ZIO[Any, AwsError, AwsUserArn] =
      AwsError.unwrapOptionField("createdByIamUser", createdByIamUser)
    def getCreatedAt: ZIO[Any, AwsError, EpochTime] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getLastUpdatedAt: ZIO[Any, AwsError, EpochTime] =
      AwsError.unwrapOptionField("lastUpdatedAt", lastUpdatedAt)
    def getName: ZIO[Any, AwsError, MLModelName] =
      AwsError.unwrapOptionField("name", name)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.machinelearning.model.EntityStatus] =
      AwsError.unwrapOptionField("status", status)
    def getSizeInBytes: ZIO[Any, AwsError, LongType] =
      AwsError.unwrapOptionField("sizeInBytes", sizeInBytes)
    def getEndpointInfo: ZIO[
      Any,
      AwsError,
      zio.aws.machinelearning.model.RealtimeEndpointInfo.ReadOnly
    ] = AwsError.unwrapOptionField("endpointInfo", endpointInfo)
    def getTrainingParameters: ZIO[Any, AwsError, Map[StringType, StringType]] =
      AwsError.unwrapOptionField("trainingParameters", trainingParameters)
    def getInputDataLocationS3: ZIO[Any, AwsError, S3Url] =
      AwsError.unwrapOptionField("inputDataLocationS3", inputDataLocationS3)
    def getAlgorithm
        : ZIO[Any, AwsError, zio.aws.machinelearning.model.Algorithm] =
      AwsError.unwrapOptionField("algorithm", algorithm)
    def getMlModelType
        : ZIO[Any, AwsError, zio.aws.machinelearning.model.MLModelType] =
      AwsError.unwrapOptionField("mlModelType", mlModelType)
    def getScoreThreshold: ZIO[Any, AwsError, ScoreThreshold] =
      AwsError.unwrapOptionField("scoreThreshold", scoreThreshold)
    def getScoreThresholdLastUpdatedAt: ZIO[Any, AwsError, EpochTime] =
      AwsError.unwrapOptionField(
        "scoreThresholdLastUpdatedAt",
        scoreThresholdLastUpdatedAt
      )
    def getMessage: ZIO[Any, AwsError, Message] =
      AwsError.unwrapOptionField("message", message)
    def getComputeTime: ZIO[Any, AwsError, LongType] =
      AwsError.unwrapOptionField("computeTime", computeTime)
    def getFinishedAt: ZIO[Any, AwsError, EpochTime] =
      AwsError.unwrapOptionField("finishedAt", finishedAt)
    def getStartedAt: ZIO[Any, AwsError, EpochTime] =
      AwsError.unwrapOptionField("startedAt", startedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.machinelearning.model.MLModel
  ) extends zio.aws.machinelearning.model.MLModel.ReadOnly {
    override val mlModelId: Option[EntityId] = scala
      .Option(impl.mlModelId())
      .map(value => zio.aws.machinelearning.model.primitives.EntityId(value))
    override val trainingDataSourceId: Option[EntityId] = scala
      .Option(impl.trainingDataSourceId())
      .map(value => zio.aws.machinelearning.model.primitives.EntityId(value))
    override val createdByIamUser: Option[AwsUserArn] = scala
      .Option(impl.createdByIamUser())
      .map(value => zio.aws.machinelearning.model.primitives.AwsUserArn(value))
    override val createdAt: Option[EpochTime] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.machinelearning.model.primitives.EpochTime(value))
    override val lastUpdatedAt: Option[EpochTime] = scala
      .Option(impl.lastUpdatedAt())
      .map(value => zio.aws.machinelearning.model.primitives.EpochTime(value))
    override val name: Option[MLModelName] = scala
      .Option(impl.name())
      .map(value => zio.aws.machinelearning.model.primitives.MLModelName(value))
    override val status: Option[zio.aws.machinelearning.model.EntityStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.machinelearning.model.EntityStatus.wrap(value))
    override val sizeInBytes: Option[LongType] = scala
      .Option(impl.sizeInBytes())
      .map(value => zio.aws.machinelearning.model.primitives.LongType(value))
    override val endpointInfo
        : Option[zio.aws.machinelearning.model.RealtimeEndpointInfo.ReadOnly] =
      scala
        .Option(impl.endpointInfo())
        .map(value =>
          zio.aws.machinelearning.model.RealtimeEndpointInfo.wrap(value)
        )
    override val trainingParameters: Option[Map[StringType, StringType]] = scala
      .Option(impl.trainingParameters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.machinelearning.model.primitives.StringType(
              key
            ) -> zio.aws.machinelearning.model.primitives.StringType(value)
          })
          .toMap
      )
    override val inputDataLocationS3: Option[S3Url] = scala
      .Option(impl.inputDataLocationS3())
      .map(value => zio.aws.machinelearning.model.primitives.S3Url(value))
    override val algorithm: Option[zio.aws.machinelearning.model.Algorithm] =
      scala
        .Option(impl.algorithm())
        .map(value => zio.aws.machinelearning.model.Algorithm.wrap(value))
    override val mlModelType
        : Option[zio.aws.machinelearning.model.MLModelType] = scala
      .Option(impl.mlModelType())
      .map(value => zio.aws.machinelearning.model.MLModelType.wrap(value))
    override val scoreThreshold: Option[ScoreThreshold] = scala
      .Option(impl.scoreThreshold())
      .map(value =>
        zio.aws.machinelearning.model.primitives.ScoreThreshold(value)
      )
    override val scoreThresholdLastUpdatedAt: Option[EpochTime] = scala
      .Option(impl.scoreThresholdLastUpdatedAt())
      .map(value => zio.aws.machinelearning.model.primitives.EpochTime(value))
    override val message: Option[Message] = scala
      .Option(impl.message())
      .map(value => zio.aws.machinelearning.model.primitives.Message(value))
    override val computeTime: Option[LongType] = scala
      .Option(impl.computeTime())
      .map(value => zio.aws.machinelearning.model.primitives.LongType(value))
    override val finishedAt: Option[EpochTime] = scala
      .Option(impl.finishedAt())
      .map(value => zio.aws.machinelearning.model.primitives.EpochTime(value))
    override val startedAt: Option[EpochTime] = scala
      .Option(impl.startedAt())
      .map(value => zio.aws.machinelearning.model.primitives.EpochTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.machinelearning.model.MLModel
  ): zio.aws.machinelearning.model.MLModel.ReadOnly = new Wrapper(impl)
}
