package zio.aws.machinelearning.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.machinelearning.model.primitives.EntityId
import scala.jdk.CollectionConverters.*
final case class DeleteDataSourceResponse(
    dataSourceId: Option[EntityId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.machinelearning.model.DeleteDataSourceResponse = {
    import DeleteDataSourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.machinelearning.model.DeleteDataSourceResponse
      .builder()
      .optionallyWith(
        dataSourceId.map(value => EntityId.unwrap(value): java.lang.String)
      )(_.dataSourceId)
      .build()
  }
  def asReadOnly
      : zio.aws.machinelearning.model.DeleteDataSourceResponse.ReadOnly =
    zio.aws.machinelearning.model.DeleteDataSourceResponse.wrap(buildAwsValue())
}
object DeleteDataSourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.machinelearning.model.DeleteDataSourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.machinelearning.model.DeleteDataSourceResponse =
      zio.aws.machinelearning.model
        .DeleteDataSourceResponse(dataSourceId.map(value => value))
    def dataSourceId: Option[EntityId]
    def getDataSourceId: ZIO[Any, AwsError, EntityId] =
      AwsError.unwrapOptionField("dataSourceId", dataSourceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.machinelearning.model.DeleteDataSourceResponse
  ) extends zio.aws.machinelearning.model.DeleteDataSourceResponse.ReadOnly {
    override val dataSourceId: Option[EntityId] = scala
      .Option(impl.dataSourceId())
      .map(value => zio.aws.machinelearning.model.primitives.EntityId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.machinelearning.model.DeleteDataSourceResponse
  ): zio.aws.machinelearning.model.DeleteDataSourceResponse.ReadOnly =
    new Wrapper(impl)
}
