package zio.aws.elasticinference.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.elasticinference.model.primitives.{
  NextToken,
  MaxResults,
  AcceleratorId
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeAcceleratorsRequest(
    acceleratorIds: Optional[Iterable[AcceleratorId]] = Optional.Absent,
    filters: Optional[Iterable[zio.aws.elasticinference.model.Filter]] =
      Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticinference.model.DescribeAcceleratorsRequest = {
    import DescribeAcceleratorsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticinference.model.DescribeAcceleratorsRequest
      .builder()
      .optionallyWith(
        acceleratorIds.map(value =>
          value.map { item =>
            AcceleratorId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.acceleratorIds)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticinference.model.DescribeAcceleratorsRequest.ReadOnly =
    zio.aws.elasticinference.model.DescribeAcceleratorsRequest
      .wrap(buildAwsValue())
}
object DescribeAcceleratorsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticinference.model.DescribeAcceleratorsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticinference.model.DescribeAcceleratorsRequest =
      zio.aws.elasticinference.model.DescribeAcceleratorsRequest(
        acceleratorIds.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def acceleratorIds: Optional[List[AcceleratorId]]
    def filters: Optional[List[zio.aws.elasticinference.model.Filter.ReadOnly]]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def getAcceleratorIds: ZIO[Any, AwsError, List[AcceleratorId]] =
      AwsError.unwrapOptionField("acceleratorIds", acceleratorIds)
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.elasticinference.model.Filter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticinference.model.DescribeAcceleratorsRequest
  ) extends zio.aws.elasticinference.model.DescribeAcceleratorsRequest.ReadOnly {
    override val acceleratorIds: Optional[List[AcceleratorId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.acceleratorIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticinference.model.primitives.AcceleratorId(item)
          }.toList
        )
    override val filters
        : Optional[List[zio.aws.elasticinference.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticinference.model.Filter.wrap(item)
          }.toList
        )
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.elasticinference.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.elasticinference.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticinference.model.DescribeAcceleratorsRequest
  ): zio.aws.elasticinference.model.DescribeAcceleratorsRequest.ReadOnly =
    new Wrapper(impl)
}
