package zio.aws.elasticinference.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeAcceleratorOfferingsResponse(
    acceleratorTypeOfferings: Optional[
      Iterable[zio.aws.elasticinference.model.AcceleratorTypeOffering]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticinference.model.DescribeAcceleratorOfferingsResponse = {
    import DescribeAcceleratorOfferingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticinference.model.DescribeAcceleratorOfferingsResponse
      .builder()
      .optionallyWith(
        acceleratorTypeOfferings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.acceleratorTypeOfferings)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticinference.model.DescribeAcceleratorOfferingsResponse.ReadOnly =
    zio.aws.elasticinference.model.DescribeAcceleratorOfferingsResponse
      .wrap(buildAwsValue())
}
object DescribeAcceleratorOfferingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticinference.model.DescribeAcceleratorOfferingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticinference.model.DescribeAcceleratorOfferingsResponse =
      zio.aws.elasticinference.model.DescribeAcceleratorOfferingsResponse(
        acceleratorTypeOfferings.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def acceleratorTypeOfferings: Optional[
      List[zio.aws.elasticinference.model.AcceleratorTypeOffering.ReadOnly]
    ]
    def getAcceleratorTypeOfferings: ZIO[Any, AwsError, List[
      zio.aws.elasticinference.model.AcceleratorTypeOffering.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "acceleratorTypeOfferings",
      acceleratorTypeOfferings
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticinference.model.DescribeAcceleratorOfferingsResponse
  ) extends zio.aws.elasticinference.model.DescribeAcceleratorOfferingsResponse.ReadOnly {
    override val acceleratorTypeOfferings: Optional[
      List[zio.aws.elasticinference.model.AcceleratorTypeOffering.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.acceleratorTypeOfferings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticinference.model.AcceleratorTypeOffering.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticinference.model.DescribeAcceleratorOfferingsResponse
  ): zio.aws.elasticinference.model.DescribeAcceleratorOfferingsResponse.ReadOnly =
    new Wrapper(impl)
}
