/*
 * Decompiled with CFR 0.152.
 */
package dev.sergiobelda.compose.vectorize.generator.task;

import dev.sergiobelda.compose.vectorize.generator.Image;
import dev.sergiobelda.compose.vectorize.generator.ImageCategories;
import dev.sergiobelda.compose.vectorize.generator.ImageCategoriesProcessor;
import dev.sergiobelda.compose.vectorize.generator.ImageCategoriesWriter;
import dev.sergiobelda.compose.vectorize.generator.ImageProcessor;
import dev.sergiobelda.compose.vectorize.generator.ImageWriter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u0017H\u0007J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0017H\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0007R\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u00020\n8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00048G\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0006R\u0016\u0010\u0011\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006R\u001e\u0010\u0013\u001a\u00020\n8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\f\"\u0004\b\u0015\u0010\u000e\u00a8\u0006\u001e"}, d2={"Ldev/sergiobelda/compose/vectorize/generator/task/ImageVectorGenerationTask;", "Lorg/gradle/api/DefaultTask;", "()V", "buildDirectory", "Ljava/io/File;", "getBuildDirectory", "()Ljava/io/File;", "setBuildDirectory", "(Ljava/io/File;)V", "generatedSrcMain", "", "getGeneratedSrcMain", "()Ljava/lang/String;", "setGeneratedSrcMain", "(Ljava/lang/String;)V", "generatedSrcMainDirectory", "getGeneratedSrcMainDirectory", "imagesDirectory", "getImagesDirectory", "packageName", "getPackageName", "setPackageName", "getImageDirectories", "", "loadImageCategories", "Ldev/sergiobelda/compose/vectorize/generator/ImageCategories;", "loadImages", "Ldev/sergiobelda/compose/vectorize/generator/Image;", "run", "", "compose-vectorize-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nImageVectorGenerationTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImageVectorGenerationTask.kt\ndev/sergiobelda/compose/vectorize/generator/task/ImageVectorGenerationTask\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,77:1\n3792#2:78\n4307#2,2:79\n*S KotlinDebug\n*F\n+ 1 ImageVectorGenerationTask.kt\ndev/sergiobelda/compose/vectorize/generator/task/ImageVectorGenerationTask\n*L\n44#1:78\n44#1:79,2\n*E\n"})
public class ImageVectorGenerationTask
extends DefaultTask {
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFiles
    @NotNull
    private final File imagesDirectory;
    @OutputDirectory
    public File buildDirectory;
    @Internal
    public String packageName;
    @Internal
    public String generatedSrcMain;

    public ImageVectorGenerationTask() {
        File file = this.getProject().getProjectDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.projectDir");
        this.imagesDirectory = FilesKt.resolve((File)file, (String)"xml-images");
    }

    @NotNull
    public final File getImagesDirectory() {
        return this.imagesDirectory;
    }

    /*
     * WARNING - void declaration
     */
    @Internal
    @NotNull
    public final List<File> getImageDirectories() {
        List list;
        File[] fileArray = this.imagesDirectory.listFiles();
        if (fileArray != null) {
            void $this$filterTo$iv$iv;
            File[] $this$filter$iv = fileArray;
            boolean $i$f$filter = false;
            File[] fileArray2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            int n = ((void)$this$filterTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void element$iv$iv;
                void it = element$iv$iv = $this$filterTo$iv$iv[i];
                boolean bl = false;
                if (!it.isDirectory()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @NotNull
    public final File getBuildDirectory() {
        File file = this.buildDirectory;
        if (file != null) {
            return file;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"buildDirectory");
        return null;
    }

    public final void setBuildDirectory(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"<set-?>");
        this.buildDirectory = file;
    }

    @NotNull
    public final String getPackageName() {
        String string = this.packageName;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"packageName");
        return null;
    }

    public final void setPackageName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.packageName = string;
    }

    @NotNull
    public final String getGeneratedSrcMain() {
        String string = this.generatedSrcMain;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"generatedSrcMain");
        return null;
    }

    public final void setGeneratedSrcMain(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.generatedSrcMain = string;
    }

    private final ImageCategories loadImageCategories() {
        return new ImageCategoriesProcessor(this.getPackageName(), this.getImageDirectories()).process();
    }

    private final List<Image> loadImages() {
        return new ImageProcessor(this.getPackageName(), this.getImageDirectories()).process();
    }

    @OutputDirectory
    @NotNull
    public final File getGeneratedSrcMainDirectory() {
        return FilesKt.resolve((File)this.getBuildDirectory(), (String)this.getGeneratedSrcMain());
    }

    @TaskAction
    public final void run() {
        new ImageCategoriesWriter(this.loadImageCategories()).generateTo(this.getGeneratedSrcMainDirectory());
        new ImageWriter(this.loadImages()).generateTo(this.getGeneratedSrcMainDirectory());
    }
}

