/*
 * Decompiled with CFR 0.152.
 */
package dev.sergiobelda.compose.vectorize.generator;

import com.squareup.kotlinpoet.FileSpec;
import dev.sergiobelda.compose.vectorize.generator.Image;
import dev.sergiobelda.compose.vectorize.generator.ImageVectorGenerator;
import dev.sergiobelda.compose.vectorize.generator.imageparser.ImageParser;
import dev.sergiobelda.compose.vectorize.generator.vector.Vector;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Ldev/sergiobelda/compose/vectorize/generator/ImageWriter;", "", "images", "", "Ldev/sergiobelda/compose/vectorize/generator/Image;", "(Ljava/util/List;)V", "generateTo", "", "outputSrcDirectory", "Ljava/io/File;", "compose-vectorize-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nImageWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImageWriter.kt\ndev/sergiobelda/compose/vectorize/generator/ImageWriter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,52:1\n1855#2,2:53\n*S KotlinDebug\n*F\n+ 1 ImageWriter.kt\ndev/sergiobelda/compose/vectorize/generator/ImageWriter\n*L\n36#1:53,2\n*E\n"})
public final class ImageWriter {
    @NotNull
    private final List<Image> images;

    public ImageWriter(@NotNull List<Image> images) {
        Intrinsics.checkNotNullParameter(images, (String)"images");
        this.images = images;
    }

    public final void generateTo(@NotNull File outputSrcDirectory) {
        Intrinsics.checkNotNullParameter((Object)outputSrcDirectory, (String)"outputSrcDirectory");
        Iterable $this$forEach$iv = this.images;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Image image = (Image)element$iv;
            boolean bl = false;
            if (!(((CharSequence)image.getFileContent()).length() > 0)) continue;
            Vector vector = new ImageParser(image).parse();
            FileSpec fileSpec = new ImageVectorGenerator(image.getKotlinName(), image.getPackageName(), image.getCategoryName(), vector).createFileSpec();
            fileSpec.writeTo(outputSrcDirectory);
        }
    }
}

