/*
 * Decompiled with CFR 0.152.
 */
package dev.sergiobelda.compose.vectorize.generator;

import dev.sergiobelda.compose.vectorize.generator.Image;
import dev.sergiobelda.compose.vectorize.generator.ImageProcessorKt;
import dev.sergiobelda.compose.vectorize.generator.utils.ProcessorUtilsKt;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0010!\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0005H\u0002J\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u0005J$\u0010\u000b\u001a\u00020\f*\b\u0012\u0004\u0012\u00020\t0\r2\u0006\u0010\u000e\u001a\u00020\u00062\b\b\u0002\u0010\u000f\u001a\u00020\u0003H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Ldev/sergiobelda/compose/vectorize/generator/ImageProcessor;", "", "packageName", "", "imagesDirectories", "", "Ljava/io/File;", "(Ljava/lang/String;Ljava/util/List;)V", "loadImages", "Ldev/sergiobelda/compose/vectorize/generator/Image;", "process", "addImages", "", "", "file", "categoryPath", "compose-vectorize-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nImageProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImageProcessor.kt\ndev/sergiobelda/compose/vectorize/generator/ImageProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,92:1\n1855#2,2:93\n1477#2:95\n1502#2,3:96\n1505#2,3:106\n372#3,7:99\n526#3:109\n511#3,6:110\n215#4,2:116\n13309#5,2:118\n*S KotlinDebug\n*F\n+ 1 ImageProcessor.kt\ndev/sergiobelda/compose/vectorize/generator/ImageProcessor\n*L\n32#1:93,2\n38#1:95\n38#1:96,3\n38#1:106,3\n38#1:99,7\n39#1:109\n39#1:110,6\n40#1:116,2\n58#1:118,2\n*E\n"})
public final class ImageProcessor {
    @NotNull
    private final String packageName;
    @NotNull
    private final List<File> imagesDirectories;

    public ImageProcessor(@NotNull String packageName, @NotNull List<? extends File> imagesDirectories) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter(imagesDirectories, (String)"imagesDirectories");
        this.packageName = packageName;
        this.imagesDirectories = imagesDirectories;
    }

    @NotNull
    public final List<Image> process() {
        return this.loadImages();
    }

    /*
     * WARNING - void declaration
     */
    private final List<Image> loadImages() {
        void $this$filterTo$iv$iv;
        Object it;
        Object element$iv$iv;
        Map $this$groupByTo$iv$iv;
        Object element$iv;
        List images = new ArrayList();
        Object $this$forEach$iv = this.imagesDirectories;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            element$iv = iterator.next();
            File file = (File)element$iv;
            boolean bl = false;
            ImageProcessor.addImages$default(this, images, file, null, 2, null);
        }
        Iterable $this$groupBy$iv = images;
        boolean $i$f$groupBy = false;
        iterator = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator<Object> bl = $this$groupByTo$iv$iv.iterator();
        while (bl.hasNext()) {
            Object object;
            element$iv$iv = bl.next();
            it = (Image)element$iv$iv;
            boolean bl2 = false;
            String string = ((Image)it).getCategoryName();
            String string2 = ((Image)it).getKotlinName();
            Locale locale = Locale.ROOT;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
            String string3 = string2.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
            String key$iv$iv = string + string3;
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl3 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map $this$filter$iv = destination$iv$iv;
        boolean $i$f$filter = false;
        $this$groupByTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        bl = $this$filterTo$iv$iv.entrySet().iterator();
        while (bl.hasNext()) {
            it = element$iv$iv = (Map.Entry)bl.next();
            boolean bl4 = false;
            if (!(((List)it.getValue()).size() > 1)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        $this$forEach$iv = destination$iv$iv;
        $i$f$forEach = false;
        iterator = $this$forEach$iv.entrySet().iterator();
        if (iterator.hasNext()) {
            Object entry = element$iv = iterator.next();
            boolean bl5 = false;
            Image image = (Image)CollectionsKt.firstOrNull((List)((List)entry.getValue()));
            throw new IllegalStateException(StringsKt.trimMargin$default((String)("Found multiple images with the same case-insensitive filename:\n                        | " + (image != null ? image.getXmlFileName() : null) + ". Generating images with the same\n                        | case-insensitive filename will cause issues on devices without\n                        | a case sensitive filesystem (OSX / Windows).\n                    "), null, (int)1, null));
        }
        return images;
    }

    private final void addImages(List<Image> $this$addImages, File file, String categoryPath) {
        if (file.isDirectory()) {
            String string = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
            String category = categoryPath + ProcessorUtilsKt.toKotlinPropertyName(string) + ".";
            File[] fileArray = file.listFiles();
            if (fileArray != null) {
                File[] $this$forEach$iv = fileArray;
                boolean $i$f$forEach = false;
                int n = $this$forEach$iv.length;
                for (int i = 0; i < n; ++i) {
                    File element$iv;
                    File child = element$iv = $this$forEach$iv[i];
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)child, (String)"child");
                    this.addImages($this$addImages, child, category);
                }
            }
        } else {
            String filename = FilesKt.getNameWithoutExtension((File)file);
            String kotlinName = ProcessorUtilsKt.toKotlinPropertyName(filename);
            String fileContent = FilesKt.readText$default((File)file, null, (int)1, null);
            $this$addImages.add(new Image(kotlinName, this.packageName, ProcessorUtilsKt.toKotlinPropertyName(categoryPath), filename, ImageProcessorKt.access$processXmlFile(fileContent)));
        }
    }

    static /* synthetic */ void addImages$default(ImageProcessor imageProcessor, List list, File file, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "";
        }
        imageProcessor.addImages(list, file, string);
    }
}

