/*
 * Decompiled with CFR 0.152.
 */
package dev.rifqimfahmi.gcv.plugin.tasks.factory;

import dev.rifqimfahmi.gcv.plugin.graph.DirectGraphNodeVisualizer;
import dev.rifqimfahmi.gcv.plugin.graph.GraphNodeVisualizer;
import dev.rifqimfahmi.gcv.plugin.graph.ReverseGraphNodeVisualizer;
import dev.rifqimfahmi.gcv.plugin.tasks.factory.ConfigGraphHelper;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFile;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Ldev/rifqimfahmi/gcv/plugin/tasks/factory/ConfigGraphHelperImpl;", "Ldev/rifqimfahmi/gcv/plugin/tasks/factory/ConfigGraphHelper;", "project", "Lorg/gradle/api/Project;", "target", "", "showCanBeResolved", "", "isReversed", "(Lorg/gradle/api/Project;Ljava/lang/String;ZZ)V", "file", "Ljava/io/File;", "getFile", "()Ljava/io/File;", "name", "getName", "()Ljava/lang/String;", "nameFormat", "getNameFormat", "createGraphNodeVisualizer", "Ldev/rifqimfahmi/gcv/plugin/graph/GraphNodeVisualizer;", "gradle-configuration-visualizer"})
public final class ConfigGraphHelperImpl
implements ConfigGraphHelper {
    private final Project project;
    private final String target;
    private final boolean showCanBeResolved;
    private final boolean isReversed;

    @Override
    @NotNull
    public GraphNodeVisualizer createGraphNodeVisualizer() {
        return this.isReversed ? (GraphNodeVisualizer)new ReverseGraphNodeVisualizer() : (GraphNodeVisualizer)new DirectGraphNodeVisualizer();
    }

    @Override
    @NotNull
    public String getName() {
        return StringsKt.isBlank((CharSequence)this.target) ? "allConfigurations" : this.target;
    }

    @Override
    @NotNull
    public String getNameFormat() {
        return this.isReversed ? this.getName() + "-reversed.svg" : this.getName() + ".svg";
    }

    @Override
    @NotNull
    public File getFile() {
        ProjectLayout projectLayout = this.project.getLayout();
        Intrinsics.checkNotNullExpressionValue((Object)projectLayout, (String)"project.layout");
        Object object = projectLayout.getBuildDirectory().file("configVisualizer/" + this.getNameFormat()).get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.layout.buildDire\u2026meFormat\"\n        ).get()");
        File file = ((RegularFile)object).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.layout.buildDire\u2026t\"\n        ).get().asFile");
        return file;
    }

    public ConfigGraphHelperImpl(@NotNull Project project, @NotNull String target, boolean showCanBeResolved, boolean isReversed) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.project = project;
        this.target = target;
        this.showCanBeResolved = showCanBeResolved;
        this.isReversed = isReversed;
    }
}

