/*
 * Decompiled with CFR 0.152.
 */
package dev.rifqimfahmi.gcv.plugin.tasks;

import dev.rifqimfahmi.gcv.plugin.graph.GraphNodeVisualizer;
import dev.rifqimfahmi.gcv.plugin.tasks.CommonTasksKt;
import dev.rifqimfahmi.gcv.plugin.tasks.factory.ConfigGraphHelper;
import dev.rifqimfahmi.gcv.plugin.tasks.factory.ConfigGraphHelperImpl;
import guru.nidi.graphviz.attribute.Font;
import guru.nidi.graphviz.engine.Format;
import guru.nidi.graphviz.engine.Graphviz;
import guru.nidi.graphviz.engine.Renderer;
import guru.nidi.graphviz.model.Factory;
import guru.nidi.graphviz.model.Graph;
import guru.nidi.graphviz.model.LinkSource;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b&\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\f\u001a\u00020\rH\u0007J\b\u0010\u000e\u001a\u00020\rH\u0002J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\bH\u0007J\b\u0010\u0012\u001a\u00020\rH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Ldev/rifqimfahmi/gcv/plugin/tasks/ConfigGraphVizTask;", "Lorg/gradle/api/DefaultTask;", "()V", "gnv", "Ldev/rifqimfahmi/gcv/plugin/graph/GraphNodeVisualizer;", "helper", "Ldev/rifqimfahmi/gcv/plugin/tasks/factory/ConfigGraphHelper;", "isReversed", "", "showCanBeResolved", "target", "", "dumpConfigurations", "", "initTask", "setConfigTarget", "setOptIsReserved", "setShowResolved", "validate", "Companion", "gradle-configuration-visualizer"})
public abstract class ConfigGraphVizTask
extends DefaultTask {
    private String target = "";
    private boolean showCanBeResolved;
    private boolean isReversed;
    private ConfigGraphHelper helper;
    private GraphNodeVisualizer gnv;
    @NotNull
    public static final String NAME = "visualizeGradleConfig";
    @NotNull
    public static final String FOLDER_NAME = "configVisualizer";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Option(option="target", description="Specific config dependency you want to check")
    public final void setConfigTarget(@NotNull String target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.target = target;
    }

    @Option(option="show-resolved", description="Show symbol on the node wether the configuration can be resolved or not")
    public final void setShowResolved(boolean showCanBeResolved) {
        this.showCanBeResolved = showCanBeResolved;
    }

    @Option(option="reverse", description="Reverse the graph to find the dependents of specified target")
    public final void setOptIsReserved(boolean isReversed) {
        this.isReversed = isReversed;
    }

    @TaskAction
    public final void dumpConfigurations() {
        this.validate();
        this.initTask();
        GraphNodeVisualizer graphNodeVisualizer = this.gnv;
        if (graphNodeVisualizer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"gnv");
        }
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        ConfigurationContainer configurationContainer = project.getConfigurations();
        Intrinsics.checkNotNullExpressionValue((Object)configurationContainer, (String)"project.configurations");
        Map<String, Set<String>> configTreeMap = graphNodeVisualizer.generateListTree(configurationContainer);
        GraphNodeVisualizer graphNodeVisualizer2 = this.gnv;
        if (graphNodeVisualizer2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"gnv");
        }
        List<LinkSource> nodes2 = graphNodeVisualizer2.visualize(configTreeMap, this.target, (Function1<? super String, String>)((Function1)new Function1<String, String>(this){
            final /* synthetic */ ConfigGraphVizTask this$0;

            @NotNull
            public final String invoke(@NotNull String $this$visualize) {
                Intrinsics.checkNotNullParameter((Object)$this$visualize, (String)"$receiver");
                GraphNodeVisualizer graphNodeVisualizer = ConfigGraphVizTask.access$getGnv$p(this.this$0);
                boolean bl = ConfigGraphVizTask.access$getShowCanBeResolved$p(this.this$0);
                Project project = this.this$0.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                ConfigurationContainer configurationContainer = project.getConfigurations();
                Intrinsics.checkNotNullExpressionValue((Object)configurationContainer, (String)"project.configurations");
                return graphNodeVisualizer.modifyNodeName(bl, $this$visualize, configurationContainer);
            }
            {
                this.this$0 = configGraphVizTask;
                super(1);
            }
        }));
        ConfigGraphHelper configGraphHelper = this.helper;
        if (configGraphHelper == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"helper");
        }
        Graph graph = ((Graph)((Graph)Factory.graph((String)configGraphHelper.getName()).directed().nodeAttr().with(Font.name((String)"arial"))).linkAttr().with("class", (Object)"link-class")).with(nodes2);
        Intrinsics.checkNotNullExpressionValue((Object)graph, (String)"graph(helper.name).direc\u2026\n            .with(nodes)");
        Graph g = graph;
        Renderer renderer = Graphviz.fromGraph((Graph)g).render(Format.SVG);
        ConfigGraphHelper configGraphHelper2 = this.helper;
        if (configGraphHelper2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"helper");
        }
        renderer.toFile(configGraphHelper2.getFile());
        StringBuilder stringBuilder = new StringBuilder().append("Here is your graph: ");
        ConfigGraphHelper configGraphHelper3 = this.helper;
        if (configGraphHelper3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"helper");
        }
        String string = stringBuilder.append(configGraphHelper3.getFile()).toString();
        System.out.println((Object)string);
    }

    private final void initTask() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        ConfigGraphHelper configGraphHelper = this.helper = (ConfigGraphHelper)new ConfigGraphHelperImpl(project, this.target, this.showCanBeResolved, this.isReversed);
        if (configGraphHelper == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"helper");
        }
        this.gnv = configGraphHelper.createGraphNodeVisualizer();
    }

    private final void validate() {
        CharSequence charSequence = this.target;
        if (charSequence.length() > 0) {
            Project project = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
            project.getConfigurations().getByName(this.target);
        }
    }

    public ConfigGraphVizTask() {
        CommonTasksKt.init(this);
        this.setDescription("Generate Gradle configuration graph svg file");
    }

    public static final /* synthetic */ GraphNodeVisualizer access$getGnv$p(ConfigGraphVizTask $this) {
        GraphNodeVisualizer graphNodeVisualizer = $this.gnv;
        if (graphNodeVisualizer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"gnv");
        }
        return graphNodeVisualizer;
    }

    public static final /* synthetic */ void access$setGnv$p(ConfigGraphVizTask $this, GraphNodeVisualizer graphNodeVisualizer) {
        $this.gnv = graphNodeVisualizer;
    }

    public static final /* synthetic */ boolean access$getShowCanBeResolved$p(ConfigGraphVizTask $this) {
        return $this.showCanBeResolved;
    }

    public static final /* synthetic */ void access$setShowCanBeResolved$p(ConfigGraphVizTask $this, boolean bl) {
        $this.showCanBeResolved = bl;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ldev/rifqimfahmi/gcv/plugin/tasks/ConfigGraphVizTask$Companion;", "", "()V", "FOLDER_NAME", "", "NAME", "gradle-configuration-visualizer"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

