/*
 * Decompiled with CFR 0.152.
 */
package dev.resteasy.junit.extension.extensions;

import dev.resteasy.junit.extension.annotations.RequestPath;
import dev.resteasy.junit.extension.annotations.RestClientConfig;
import dev.resteasy.junit.extension.api.InjectionProducer;
import dev.resteasy.junit.extension.extensions.Extensions;
import dev.resteasy.junit.extension.extensions.InstanceManager;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.UriBuilder;
import java.lang.annotation.Annotation;
import org.junit.jupiter.api.extension.ExtensionContext;

public class WebTargetProducer
implements InjectionProducer {
    @Override
    public boolean canInject(ExtensionContext context, Class<?> clazz, Annotation ... qualifiers) {
        return WebTarget.class.isAssignableFrom(clazz);
    }

    @Override
    public Object produce(ExtensionContext context, Class<?> clazz, Annotation ... qualifiers) throws IllegalArgumentException {
        if (WebTarget.class.isAssignableFrom(clazz)) {
            RestClientConfig restClient = Extensions.findQualifier(RestClientConfig.class, qualifiers);
            Client client = Extensions.findOrCreateClient(context, restClient);
            RequestPath requestPath = Extensions.findQualifier(RequestPath.class, qualifiers);
            UriBuilder uriBuilder = InstanceManager.getInstance(context).orElseThrow(() -> new RuntimeException("Could not find associated SeBootstrap instance")).instance().configuration().baseUriBuilder();
            if (requestPath != null) {
                return client.target(uriBuilder).path(requestPath.value());
            }
            return client.target(uriBuilder);
        }
        throw new IllegalArgumentException(String.format("Type %s is not assignable to %s", clazz.getName(), Client.class));
    }
}

