/*
 * Decompiled with CFR 0.152.
 */
package dev.resteasy.junit.extension.extensions;

import dev.resteasy.junit.extension.annotations.RestBootstrap;
import dev.resteasy.junit.extension.api.ConfigurationProvider;
import dev.resteasy.junit.extension.extensions.Extensions;
import jakarta.ws.rs.SeBootstrap;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.commons.support.SearchOption;

class InstanceManager
implements ExtensionContext.Store.CloseableResource {
    private static final String MANGER_KEY = "InstanceManager";
    private final ReadWriteLock lock;
    private final Class<?> testClass;
    private BootstrapHolder holder;

    public InstanceManager(Class<?> testClass) {
        this.testClass = testClass;
        this.lock = new ReentrantReadWriteLock();
    }

    public void close() {
        this.stopInstance();
    }

    static Optional<InstanceManager> getInstance(ExtensionContext context) {
        ExtensionContext.Store store = InstanceManager.getStore(context);
        return Optional.ofNullable((InstanceManager)store.get((Object)MANGER_KEY, InstanceManager.class));
    }

    static Optional<InstanceManager> removeInstance(ExtensionContext context) {
        ExtensionContext.Store store = InstanceManager.getStore(context);
        return Optional.ofNullable((InstanceManager)store.remove((Object)MANGER_KEY, InstanceManager.class));
    }

    static InstanceManager getOrCreateInstance(ExtensionContext context) {
        ExtensionContext.Store store = InstanceManager.getStore(context);
        return (InstanceManager)store.getOrComputeIfAbsent((Object)MANGER_KEY, key -> new InstanceManager(context.getRequiredTestClass()), InstanceManager.class);
    }

    RestBootstrap bootstrap() {
        this.lock.readLock().lock();
        try {
            if (this.holder == null) {
                throw new IllegalStateException("The bootstrap instance has not been started");
            }
            RestBootstrap restBootstrap = this.holder.bootstrap;
            return restBootstrap;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    SeBootstrap.Instance instance() {
        this.lock.readLock().lock();
        try {
            if (this.holder == null) {
                throw new IllegalStateException("The bootstrap instance has not been started");
            }
            SeBootstrap.Instance instance = this.holder.instance;
            return instance;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    void startInstance() throws ExecutionException, InterruptedException {
        this.lock.readLock().lock();
        try {
            if (this.holder != null) {
                return;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        this.lock.writeLock().lock();
        try {
            Optional bootstrap = AnnotationSupport.findAnnotation(this.testClass, RestBootstrap.class, (SearchOption)SearchOption.INCLUDE_ENCLOSING_CLASSES);
            if (bootstrap.isEmpty()) {
                return;
            }
            this.holder = new BootstrapHolder();
            this.holder.bootstrap = (RestBootstrap)bootstrap.get();
            Class<? extends ConfigurationProvider> factoryType = this.holder.bootstrap.configFactory();
            ConfigurationProvider factory = Extensions.createProvider(factoryType);
            this.holder.instance = (SeBootstrap.Instance)SeBootstrap.start(this.holder.bootstrap.value(), (SeBootstrap.Configuration)factory.getConfiguration()).toCompletableFuture().get(this.holder.bootstrap.timeout(), this.holder.bootstrap.timoutUnit());
        }
        catch (TimeoutException e) {
            throw new AssertionError(String.format("Failed to start the SeBootstrap instance in %d %s", this.holder.bootstrap.timeout(), this.holder.bootstrap.timoutUnit().toChronoUnit()), e);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    void stopInstance() {
        if (this.holder != null) {
            this.lock.writeLock().lock();
            try {
                if (this.holder.instance != null) {
                    this.holder.instance.stop().toCompletableFuture().get(this.holder.bootstrap.timeout(), this.holder.bootstrap.timoutUnit());
                }
            }
            catch (TimeoutException e) {
                throw new AssertionError(String.format("Failed to stop the SeBootstrap instance in %d %s", this.holder.bootstrap.timeout(), this.holder.bootstrap.timoutUnit().toChronoUnit()), e);
            }
            catch (InterruptedException e) {
            }
            catch (ExecutionException e) {
                throw new AssertionError("Failed waiting for the server to stop", e);
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    private static ExtensionContext.Store getStore(ExtensionContext context) {
        return context.getRoot().getStore(ExtensionContext.Namespace.create((Object[])new Object[]{"SeBootstrap.Store"}));
    }

    private static class BootstrapHolder {
        private RestBootstrap bootstrap;
        private SeBootstrap.Instance instance;

        private BootstrapHolder() {
        }
    }
}

