/*
 * Decompiled with CFR 0.152.
 */
package dev.resteasy.junit.extension.extensions;

import dev.resteasy.junit.extension.api.InjectionProducer;
import jakarta.inject.Inject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ServiceLoader;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.function.Predicate;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionConfigurationException;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.platform.commons.support.AnnotationSupport;

public class InjectionProducerExtension
implements BeforeAllCallback,
BeforeEachCallback,
AfterAllCallback,
ParameterResolver {
    private final BlockingDeque<AutoCloseable> resources = new LinkedBlockingDeque<AutoCloseable>();
    private final ServiceLoader<InjectionProducer> producers = ServiceLoader.load(InjectionProducer.class);

    public void beforeAll(ExtensionContext context) {
        this.injectStaticFields(context, context.getRequiredTestClass());
    }

    public void beforeEach(ExtensionContext context) {
        context.getRequiredTestInstances().getAllInstances().forEach(instance -> this.injectInstanceFields(context, instance));
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        for (InjectionProducer producer : this.producers) {
            if (!producer.canInject(extensionContext, parameterContext.getParameter().getType(), parameterContext.getParameter().getAnnotations())) continue;
            return true;
        }
        return false;
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        InjectionProducer injectionProducer = null;
        for (InjectionProducer producer : this.producers) {
            if (!producer.canInject(extensionContext, parameterContext.getParameter().getType(), parameterContext.getParameter().getAnnotations())) continue;
            injectionProducer = producer;
            break;
        }
        if (injectionProducer == null) {
            return null;
        }
        try {
            Object value = injectionProducer.produce(extensionContext, parameterContext.getParameter().getType(), parameterContext.getParameter().getAnnotations());
            if (value instanceof AutoCloseable) {
                this.resources.add((AutoCloseable)value);
            }
            return value;
        }
        catch (Throwable e) {
            throw new ParameterResolutionException(String.format("Failed to resolve parameter '%s'.", parameterContext.getParameter()), e);
        }
    }

    public void afterAll(ExtensionContext context) {
        AutoCloseable closeable;
        while ((closeable = (AutoCloseable)this.resources.pollFirst()) != null) {
            try {
                closeable.close();
            }
            catch (Throwable throwable) {}
        }
    }

    private void injectStaticFields(ExtensionContext context, Class<?> testClass) {
        this.injectFields(context, null, testClass, f -> Modifier.isStatic(f.getModifiers()));
    }

    private void injectInstanceFields(ExtensionContext context, Object instance) {
        this.injectFields(context, instance, instance.getClass(), f -> !Modifier.isStatic(f.getModifiers()));
    }

    private void injectFields(ExtensionContext context, Object testInstance, Class<?> testClass, Predicate<Field> predicate) {
        AnnotationSupport.findAnnotatedFields(testClass, Inject.class, predicate).forEach(field -> {
            if (Modifier.isFinal(field.getModifiers())) {
                throw new ExtensionConfigurationException(String.format("Field '%s' cannot be final for injecting a REST client.", field));
            }
            InjectionProducer injectionProducer = null;
            for (InjectionProducer producer : this.producers) {
                if (!producer.canInject(context, field.getType(), field.getAnnotations())) continue;
                injectionProducer = producer;
                break;
            }
            if (injectionProducer == null) {
                throw new ExtensionConfigurationException(String.format("Could not find InjectionProducer for field '%s' of type %s.", field, field.getType().getName()));
            }
            try {
                Object value = injectionProducer.produce(context, field.getType(), field.getAnnotations());
                if (value instanceof AutoCloseable) {
                    this.resources.add((AutoCloseable)value);
                }
                if (!field.trySetAccessible()) {
                    throw new ParameterResolutionException(String.format("Could not make field %s accessible for injection.", field));
                }
                field.set(testInstance, value);
            }
            catch (Throwable e) {
                throw new ParameterResolutionException(String.format("Could not make field %s accessible for injection.", field));
            }
        });
    }
}

