/*
 * Decompiled with CFR 0.152.
 */
package dev.resteasy.junit.extension.extensions;

import dev.resteasy.junit.extension.annotations.RestClientConfig;
import dev.resteasy.junit.extension.api.RestClientBuilderProvider;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import java.lang.annotation.Annotation;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import org.junit.jupiter.api.extension.ExtensionContext;

class Extensions {
    private static final ExtensionContext.Namespace CLIENT_NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{Client.class});
    private static final String CLIENT_KEY = "client";

    Extensions() {
    }

    static <T> T createProvider(Class<? extends T> factoryType) {
        if (factoryType.isInterface()) {
            Class[] interfaces = new Class[]{factoryType};
            return (T)Proxy.newProxyInstance(factoryType.getClassLoader(), interfaces, (proxy, method, args) -> MethodHandles.privateLookupIn(factoryType, MethodHandles.lookup()).in(factoryType).unreflectSpecial(method, factoryType).bindTo(proxy).invokeWithArguments(new Object[0]));
        }
        try {
            Constructor<T> constructor = factoryType.getConstructor(new Class[0]);
            return constructor.newInstance(new Object[0]);
        }
        catch (InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(String.format("Failed to create provider %s", factoryType.getName()), e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(String.format("Failed to find no-arg constructor for type %s", factoryType.getName()), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(String.format("Constructor for %s is not public.", factoryType.getName()), e);
        }
    }

    static <T extends Annotation> T findQualifier(Class<T> qualifier, Annotation[] qualifiers) {
        for (Annotation annotation : qualifiers) {
            if (!annotation.annotationType().equals(qualifier)) continue;
            return (T)((Annotation)qualifier.cast(annotation));
        }
        return null;
    }

    static Client findOrCreateClient(ExtensionContext context, RestClientConfig restClientConfig) {
        ExtensionContext.Store store = context.getStore(CLIENT_NAMESPACE);
        String key = "client-" + String.valueOf(UUID.randomUUID());
        if (restClientConfig == null) {
            return ((ClientStore)store.getOrComputeIfAbsent((Object)key, (Function<String, ClientStore>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$findOrCreateClient$1(java.lang.String ), (Ljava/lang/String;)Ldev/resteasy/junit/extension/extensions/Extensions$ClientStore;)(), ClientStore.class)).client;
        }
        Class<? extends RestClientBuilderProvider> factoryType = restClientConfig.value();
        RestClientBuilderProvider factory = Extensions.createProvider(factoryType);
        ClientBuilder builder = factory.getClientBuilder();
        return ((ClientStore)store.getOrComputeIfAbsent((Object)key, (Function<String, ClientStore>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$findOrCreateClient$2(jakarta.ws.rs.client.ClientBuilder java.lang.String ), (Ljava/lang/String;)Ldev/resteasy/junit/extension/extensions/Extensions$ClientStore;)((ClientBuilder)builder), ClientStore.class)).client;
    }

    private static /* synthetic */ ClientStore lambda$findOrCreateClient$2(ClientBuilder builder, String s) {
        return new ClientStore(CLIENT_KEY, builder.build());
    }

    private static /* synthetic */ ClientStore lambda$findOrCreateClient$1(String s) {
        return new ClientStore(CLIENT_KEY, ClientBuilder.newClient());
    }

    private static class ClientStore
    implements ExtensionContext.Store.CloseableResource {
        private final String key;
        private final Client client;

        private ClientStore(String key, Client client) {
            this.key = key;
            this.client = client;
        }

        public void close() {
            this.client.close();
        }

        public int hashCode() {
            return Objects.hash(this.key);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ClientStore)) {
                return false;
            }
            ClientStore other = (ClientStore)obj;
            return Objects.equals(this.key, other.key);
        }

        public String toString() {
            return "ClientStore[key='" + this.key + "client=" + String.valueOf(this.client) + "]";
        }
    }
}

