/*
 * Decompiled with CFR 0.152.
 */
package dev.paseto.jpaseto.crypto.sodium;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import org.apache.tuweni.crypto.sodium.Sodium;

final class Blake2b {
    private Blake2b() {
    }

    static byte[] hash(int hashLength, byte[] bytes, byte[] key) {
        byte[] output = new byte[hashLength];
        try {
            Method blake2b = Sodium.class.getDeclaredMethod("crypto_generichash_blake2b", byte[].class, Long.TYPE, byte[].class, Long.TYPE, byte[].class, Long.TYPE);
            AccessController.doPrivileged(() -> {
                blake2b.setAccessible(true);
                return blake2b;
            }).invoke(null, output, output.length, bytes, bytes.length, key, key.length);
            return output;
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Failed to find method 'crypto_generichash_blake2b' in: " + Sodium.class, e);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalStateException("Failed to calculate BLAKE2b digest", e);
        }
    }
}

