/*
 * Decompiled with CFR 0.152.
 */
package dev.paseto.jpaseto.impl;

import dev.paseto.jpaseto.PasetoV1PublicBuilder;
import dev.paseto.jpaseto.impl.AbstractPasetoBuilder;
import dev.paseto.jpaseto.impl.CryptoProviders;
import dev.paseto.jpaseto.impl.crypto.V1PublicCryptoProvider;
import java.security.PrivateKey;

public class DefaultPasetoV1PublicBuilder
extends AbstractPasetoBuilder<PasetoV1PublicBuilder>
implements PasetoV1PublicBuilder {
    private static final String HEADER = "v1.public.";
    private PrivateKey privateKey;
    private final V1PublicCryptoProvider cryptoProvider;

    public DefaultPasetoV1PublicBuilder() {
        this(CryptoProviders.v1PublicCryptoProvider());
    }

    private DefaultPasetoV1PublicBuilder(V1PublicCryptoProvider cryptoProvider) {
        this.cryptoProvider = cryptoProvider;
    }

    public PasetoV1PublicBuilder setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
        return this;
    }

    public String compact() {
        byte[] payload = this.payloadAsBytes();
        byte[] footer = this.footerAsBytes();
        byte[] signature = this.cryptoProvider.sign(payload, footer, this.privateKey);
        return HEADER + this.noPadBase64(payload, signature) + this.footerToString(footer);
    }
}

