/*
 * Decompiled with CFR 0.152.
 */
package dev.paseto.jpaseto.impl;

import dev.paseto.jpaseto.PasetoBuilder;
import dev.paseto.jpaseto.impl.lang.Bytes;
import dev.paseto.jpaseto.io.Serializer;
import dev.paseto.jpaseto.lang.Collections;
import dev.paseto.jpaseto.lang.Services;
import dev.paseto.jpaseto.lang.Strings;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;

abstract class AbstractPasetoBuilder<T extends PasetoBuilder>
implements PasetoBuilder<T> {
    private final Map<String, Object> payload = new HashMap<String, Object>();
    private final Map<String, Object> footer = new HashMap<String, Object>();
    private String footerString = null;
    private Serializer<Map<String, Object>> serializer;

    AbstractPasetoBuilder() {
    }

    public T claim(String key, Object value) {
        this.payload.put(key, value);
        return this.self();
    }

    public T footerClaim(String key, Object value) {
        this.footer.put(key, value);
        return this.self();
    }

    public T setFooter(String footer) {
        this.footerString = footer;
        return this.self();
    }

    private T self() {
        return (T)this;
    }

    protected Serializer<Map<String, Object>> getSerializer() {
        if (this.serializer == null) {
            return (Serializer)Services.loadFirst(Serializer.class);
        }
        return this.serializer;
    }

    public T setSerializer(Serializer<Map<String, Object>> serializer) {
        this.serializer = serializer;
        return this.self();
    }

    protected String footerToString(byte[] footer) {
        if (footer == null || footer.length == 0) {
            return "";
        }
        return "." + this.noPadBase64(new byte[][]{footer});
    }

    protected String noPadBase64(byte[] ... inputs) {
        return Base64.getUrlEncoder().withoutPadding().encodeToString(Bytes.concat(inputs));
    }

    protected byte[] payloadAsBytes() {
        return this.getSerializer().serialize(this.getPayload());
    }

    protected byte[] footerAsBytes() {
        if (Strings.hasText((String)this.getFooterString())) {
            return this.getFooterString().getBytes(StandardCharsets.UTF_8);
        }
        Map<String, Object> tmpFooter = this.getFooter();
        if (!Collections.isEmpty(tmpFooter)) {
            return this.getSerializer().serialize(tmpFooter);
        }
        return new byte[0];
    }

    protected Map<String, Object> getPayload() {
        return this.payload;
    }

    protected Map<String, Object> getFooter() {
        return this.footer;
    }

    protected String getFooterString() {
        return this.footerString;
    }
}

