/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.sdk;

import dev.openfeature.sdk.Client;
import dev.openfeature.sdk.EvaluationContext;
import dev.openfeature.sdk.FeatureProvider;
import dev.openfeature.sdk.Hook;
import dev.openfeature.sdk.Metadata;
import dev.openfeature.sdk.OpenFeatureClient;
import dev.openfeature.sdk.internal.AutoCloseableLock;
import dev.openfeature.sdk.internal.AutoCloseableReentrantReadWriteLock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;

public class OpenFeatureAPI {
    static AutoCloseableReentrantReadWriteLock hooksLock = new AutoCloseableReentrantReadWriteLock();
    static AutoCloseableReentrantReadWriteLock providerLock = new AutoCloseableReentrantReadWriteLock();
    static AutoCloseableReentrantReadWriteLock contextLock = new AutoCloseableReentrantReadWriteLock();
    private FeatureProvider provider;
    private EvaluationContext evaluationContext;
    private List<Hook> apiHooks = new ArrayList<Hook>();

    private OpenFeatureAPI() {
    }

    public static OpenFeatureAPI getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public Metadata getProviderMetadata() {
        return this.provider.getMetadata();
    }

    public Client getClient() {
        return this.getClient(null, null);
    }

    public Client getClient(@Nullable String name) {
        return this.getClient(name, null);
    }

    public Client getClient(@Nullable String name, @Nullable String version) {
        return new OpenFeatureClient(this, name, version);
    }

    public void setEvaluationContext(EvaluationContext evaluationContext) {
        try (AutoCloseableLock __ = contextLock.writeLockAutoCloseable();){
            this.evaluationContext = evaluationContext;
        }
    }

    public EvaluationContext getEvaluationContext() {
        try (AutoCloseableLock __ = contextLock.readLockAutoCloseable();){
            EvaluationContext evaluationContext = this.evaluationContext;
            return evaluationContext;
        }
    }

    public void setProvider(FeatureProvider provider) {
        try (AutoCloseableLock __ = providerLock.writeLockAutoCloseable();){
            this.provider = provider;
        }
    }

    public FeatureProvider getProvider() {
        try (AutoCloseableLock __ = providerLock.readLockAutoCloseable();){
            FeatureProvider featureProvider = this.provider;
            return featureProvider;
        }
    }

    public void addHooks(Hook ... hooks) {
        try (AutoCloseableLock __ = hooksLock.writeLockAutoCloseable();){
            this.apiHooks.addAll(Arrays.asList(hooks));
        }
    }

    public List<Hook> getHooks() {
        try (AutoCloseableLock __ = hooksLock.readLockAutoCloseable();){
            List<Hook> list = this.apiHooks;
            return list;
        }
    }

    public void clearHooks() {
        try (AutoCloseableLock __ = hooksLock.writeLockAutoCloseable();){
            this.apiHooks.clear();
        }
    }

    private static class SingletonHolder {
        private static final OpenFeatureAPI INSTANCE = new OpenFeatureAPI();

        private SingletonHolder() {
        }
    }
}

