/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.sdk;

import dev.openfeature.sdk.DefaultHookData;
import dev.openfeature.sdk.EvaluationContext;
import dev.openfeature.sdk.FlagEvaluationDetails;
import dev.openfeature.sdk.FlagValueType;
import dev.openfeature.sdk.Hook;
import dev.openfeature.sdk.HookContext;
import dev.openfeature.sdk.HookSupportData;
import dev.openfeature.sdk.LayeredEvaluationContext;
import dev.openfeature.sdk.Pair;
import dev.openfeature.sdk.SharedHookContext;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HookSupport {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HookSupport.class);

    HookSupport() {
    }

    public void setHooks(HookSupportData hookSupportData, List<Hook> hooks, FlagValueType type) {
        ArrayList<Pair<Hook, HookContext>> hookContextPairs = new ArrayList<Pair<Hook, HookContext>>();
        for (Hook hook : hooks) {
            if (!hook.supportsFlagValueType(type)) continue;
            hookContextPairs.add(Pair.of(hook, null));
        }
        hookSupportData.hooks = hookContextPairs;
    }

    public void setHookContexts(HookSupportData hookSupportData, SharedHookContext sharedContext, LayeredEvaluationContext evaluationContext) {
        for (int i = 0; i < hookSupportData.hooks.size(); ++i) {
            Pair<Hook, HookContext> hookContextPair = hookSupportData.hooks.get(i);
            HookContext curHookContext = sharedContext.hookContextFor(evaluationContext, new DefaultHookData());
            hookContextPair.setValue(curHookContext);
        }
    }

    public void executeBeforeHooks(HookSupportData data) {
        ArrayList<Pair<Hook, HookContext>> reversedHooks = new ArrayList<Pair<Hook, HookContext>>(data.getHooks());
        Collections.reverse(reversedHooks);
        for (Pair pair : reversedHooks) {
            EvaluationContext returnedContext;
            HookContext hookContext;
            Hook hook = (Hook)pair.getKey();
            Optional returnedEvalContext = Optional.ofNullable(hook.before(hookContext = (HookContext)pair.getValue(), data.getHints())).orElse(Optional.empty());
            if (!returnedEvalContext.isPresent() || (returnedContext = (EvaluationContext)returnedEvalContext.get()) == hookContext.getCtx() || returnedContext.isEmpty()) continue;
            data.evaluationContext.putHookContext(returnedContext);
        }
    }

    public void executeErrorHooks(HookSupportData data, Exception error) {
        for (Pair<Hook, HookContext> hookContextPair : data.getHooks()) {
            Hook hook = hookContextPair.getKey();
            HookContext hookContext = hookContextPair.getValue();
            try {
                hook.error(hookContext, error, data.getHints());
            }
            catch (Exception e) {
                log.error("Unhandled exception when running {} hook {} (only 'after' hooks should throw)", new Object[]{"error", hook.getClass(), e});
            }
        }
    }

    public <T> void executeAfterHooks(HookSupportData data, FlagEvaluationDetails<T> details) {
        for (Pair<Hook, HookContext> hookContextPair : data.getHooks()) {
            Hook hook = hookContextPair.getKey();
            HookContext hookContext = hookContextPair.getValue();
            hook.after(hookContext, details, data.getHints());
        }
    }

    public <T> void executeAfterAllHooks(HookSupportData data, FlagEvaluationDetails<T> details) {
        for (Pair<Hook, HookContext> hookContextPair : data.getHooks()) {
            Hook hook = hookContextPair.getKey();
            HookContext hookContext = hookContextPair.getValue();
            try {
                hook.finallyAfter(hookContext, details, data.getHints());
            }
            catch (Exception e) {
                log.error("Unhandled exception when running {} hook {} (only 'after' hooks should throw)", new Object[]{"finally", hook.getClass(), e});
            }
        }
    }
}

