/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.sdk;

import java.util.HashMap;
import java.util.Map;

public interface HookData {
    public void set(String var1, Object var2);

    public Object get(String var1);

    public <T> T get(String var1, Class<T> var2);

    public static HookData create() {
        return new DefaultHookData();
    }

    public static class DefaultHookData
    implements HookData {
        private Map<String, Object> data;

        @Override
        public void set(String key, Object value) {
            if (this.data == null) {
                this.data = new HashMap<String, Object>();
            }
            this.data.put(key, value);
        }

        @Override
        public Object get(String key) {
            if (this.data == null) {
                return null;
            }
            return this.data.get(key);
        }

        @Override
        public <T> T get(String key, Class<T> type) {
            Object value = this.get(key);
            if (value == null) {
                return null;
            }
            if (!type.isInstance(value)) {
                throw new ClassCastException("Value for key '" + key + "' is not of type " + type.getName());
            }
            return type.cast(value);
        }
    }
}

