/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.sdk;

import dev.openfeature.sdk.EvaluationContext;
import dev.openfeature.sdk.FlagEvaluationDetails;
import dev.openfeature.sdk.FlagValueType;
import dev.openfeature.sdk.Hook;
import dev.openfeature.sdk.HookContext;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HookSupport {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HookSupport.class);

    public EvaluationContext beforeHooks(FlagValueType flagValueType, HookContext hookCtx, List<Hook> hooks, Map<String, Object> hints) {
        Stream<EvaluationContext> result = this.callBeforeHooks(flagValueType, hookCtx, hooks, hints);
        return hookCtx.getCtx().merge(result.reduce(hookCtx.getCtx(), (accumulated, current) -> accumulated.merge((EvaluationContext)current)));
    }

    public void afterHooks(FlagValueType flagValueType, HookContext hookContext, FlagEvaluationDetails details, List<Hook> hooks, Map<String, Object> hints) {
        this.executeHooksUnchecked(flagValueType, hooks, hook -> hook.after(hookContext, details, hints));
    }

    public void afterAllHooks(FlagValueType flagValueType, HookContext hookCtx, List<Hook> hooks, Map<String, Object> hints) {
        this.executeHooks(flagValueType, hooks, "finally", hook -> hook.finallyAfter(hookCtx, hints));
    }

    public void errorHooks(FlagValueType flagValueType, HookContext hookCtx, Exception e, List<Hook> hooks, Map<String, Object> hints) {
        this.executeHooks(flagValueType, hooks, "error", hook -> hook.error(hookCtx, e, hints));
    }

    private <T> void executeHooks(FlagValueType flagValueType, List<Hook> hooks, String hookMethod, Consumer<Hook<T>> hookCode) {
        if (hooks != null) {
            hooks.stream().filter(hook -> hook.supportsFlagValueType(flagValueType)).forEach(hook -> this.executeChecked((Hook)hook, hookCode, hookMethod));
        }
    }

    private <T> void executeChecked(Hook<T> hook, Consumer<Hook<T>> hookCode, String hookMethod) {
        try {
            hookCode.accept(hook);
        }
        catch (Exception exception) {
            log.error("Unhandled exception when running {} hook {} (only 'after' hooks should throw)", new Object[]{hookMethod, hook.getClass(), exception});
        }
    }

    private <T> void executeHooksUnchecked(FlagValueType flagValueType, List<Hook> hooks, Consumer<Hook<T>> hookCode) {
        if (hooks != null) {
            hooks.stream().filter(hook -> hook.supportsFlagValueType(flagValueType)).forEach(hookCode::accept);
        }
    }

    private Stream<EvaluationContext> callBeforeHooks(FlagValueType flagValueType, HookContext hookCtx, List<Hook> hooks, Map<String, Object> hints) {
        List reversedHooks = IntStream.range(0, hooks.size()).map(i -> hooks.size() - 1 - i).mapToObj(hooks::get).collect(Collectors.toList());
        return reversedHooks.stream().filter(hook -> hook.supportsFlagValueType(flagValueType)).map(hook -> hook.before(hookCtx, hints)).filter(Objects::nonNull).filter(Optional::isPresent).map(Optional::get).map(EvaluationContext.class::cast);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public HookSupport() {
    }
}

