/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.platform.jni.internal.plugins;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import dev.nokee.language.base.internal.GeneratedSourceSet;
import dev.nokee.language.c.internal.CSourceSet;
import dev.nokee.language.cpp.internal.CppSourceSet;
import dev.nokee.language.nativebase.internal.HeaderExportingSourceSet;
import dev.nokee.language.nativebase.internal.HeaderExportingSourceSetInternal;
import dev.nokee.language.nativebase.internal.plugins.NativePlatformCapabilitiesMarkerPlugin;
import dev.nokee.language.objectivec.internal.ObjectiveCSourceSet;
import dev.nokee.language.objectivecpp.internal.ObjectiveCppSourceSet;
import dev.nokee.language.swift.internal.SwiftSourceSet;
import dev.nokee.platform.base.internal.BuildVariant;
import dev.nokee.platform.base.internal.GroupId;
import dev.nokee.platform.base.internal.NamingScheme;
import dev.nokee.platform.base.internal.NamingSchemeFactory;
import dev.nokee.platform.base.internal.VariantProvider;
import dev.nokee.platform.jni.JniLibrary;
import dev.nokee.platform.jni.JniLibraryExtension;
import dev.nokee.platform.jni.internal.AbstractJarBinary;
import dev.nokee.platform.jni.internal.DefaultJvmJarBinary;
import dev.nokee.platform.jni.internal.IncompatiblePluginUsage;
import dev.nokee.platform.jni.internal.JniLibraryComponentInternal;
import dev.nokee.platform.jni.internal.JniLibraryDependenciesInternal;
import dev.nokee.platform.jni.internal.JniLibraryExtensionInternal;
import dev.nokee.platform.jni.internal.JniLibraryInternal;
import dev.nokee.platform.jni.internal.JniLibraryNativeDependenciesInternal;
import dev.nokee.platform.nativebase.internal.ConfigurationUtils;
import dev.nokee.platform.nativebase.internal.NativeLanguageRules;
import dev.nokee.platform.nativebase.internal.TargetMachineRule;
import dev.nokee.platform.nativebase.internal.ToolChainSelectorInternal;
import dev.nokee.platform.nativebase.internal.dependencies.DefaultHeaderIncomingDependencies;
import dev.nokee.platform.nativebase.internal.dependencies.DefaultNativeComponentDependencies;
import dev.nokee.platform.nativebase.internal.dependencies.DefaultSwiftModuleIncomingDependencies;
import dev.nokee.platform.nativebase.internal.dependencies.HeaderIncomingDependencies;
import dev.nokee.platform.nativebase.internal.dependencies.NativeIncomingDependencies;
import dev.nokee.platform.nativebase.internal.dependencies.NoHeaderIncomingDependencies;
import dev.nokee.platform.nativebase.internal.dependencies.NoSwiftModuleIncomingDependencies;
import dev.nokee.platform.nativebase.internal.dependencies.SwiftModuleIncomingDependencies;
import dev.nokee.platform.nativebase.tasks.LinkSharedLibrary;
import dev.nokee.platform.nativebase.tasks.internal.LinkSharedLibraryTask;
import dev.nokee.runtime.darwin.internal.plugins.DarwinFrameworkResolutionSupportPlugin;
import dev.nokee.runtime.nativebase.TargetMachine;
import dev.nokee.runtime.nativebase.internal.DefaultMachineArchitecture;
import dev.nokee.runtime.nativebase.internal.DefaultOperatingSystemFamily;
import dev.nokee.runtime.nativebase.internal.DefaultTargetMachine;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.attributes.LibraryElements;
import org.gradle.api.attributes.Usage;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFile;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.api.tasks.testing.Test;
import org.gradle.jvm.tasks.Jar;
import org.gradle.language.nativeplatform.internal.toolchains.ToolChainSelector;
import org.gradle.language.plugins.NativeBasePlugin;
import org.gradle.nativeplatform.toolchain.internal.plugins.StandardToolChainsPlugin;
import org.gradle.process.CommandLineArgumentProvider;
import org.gradle.util.GradleVersion;

public abstract class JniLibraryPlugin
implements Plugin<Project> {
    private static final String EXTENSION_NAME = "library";
    private final ToolChainSelectorInternal toolChainSelector = (ToolChainSelectorInternal)this.getObjects().newInstance(ToolChainSelectorInternal.class, new Object[0]);

    @Inject
    protected abstract ProviderFactory getProviders();

    @Inject
    protected abstract TaskContainer getTasks();

    @Inject
    protected abstract ConfigurationContainer getConfigurations();

    @Inject
    protected abstract ProjectLayout getLayout();

    private JniLibraryNativeDependenciesInternal newDependencies(NamingScheme names, BuildVariant buildVariant, JniLibraryComponentInternal component) {
        DefaultNativeComponentDependencies variantDependencies = component.getDependencies().getNativeDelegate();
        if (((Set)component.getBuildVariants().get()).size() > 1) {
            variantDependencies = variantDependencies.extendsWith(names.withConfigurationNamePrefix("native"));
        }
        boolean hasSwift = !component.getSourceCollection().withType(SwiftSourceSet.class).isEmpty();
        boolean hasHeader = !component.getSourceCollection().matching(it -> it instanceof HeaderExportingSourceSet).isEmpty();
        SwiftModuleIncomingDependencies incomingSwiftDependencies = null;
        HeaderIncomingDependencies incomingHeaderDependencies = null;
        if (hasSwift) {
            incomingSwiftDependencies = (SwiftModuleIncomingDependencies)this.getObjects().newInstance(DefaultSwiftModuleIncomingDependencies.class, new Object[]{names, variantDependencies});
            incomingHeaderDependencies = (HeaderIncomingDependencies)this.getObjects().newInstance(NoHeaderIncomingDependencies.class, new Object[0]);
        } else if (hasHeader) {
            incomingHeaderDependencies = (HeaderIncomingDependencies)this.getObjects().newInstance(DefaultHeaderIncomingDependencies.class, new Object[]{names, variantDependencies, buildVariant});
            incomingSwiftDependencies = (SwiftModuleIncomingDependencies)this.getObjects().newInstance(NoSwiftModuleIncomingDependencies.class, new Object[0]);
        } else {
            incomingHeaderDependencies = (HeaderIncomingDependencies)this.getObjects().newInstance(NoHeaderIncomingDependencies.class, new Object[0]);
            incomingSwiftDependencies = (SwiftModuleIncomingDependencies)this.getObjects().newInstance(NoSwiftModuleIncomingDependencies.class, new Object[0]);
        }
        NativeIncomingDependencies incoming = (NativeIncomingDependencies)this.getObjects().newInstance(NativeIncomingDependencies.class, new Object[]{names.withConfigurationNamePrefix("native"), buildVariant, variantDependencies, incomingSwiftDependencies, incomingHeaderDependencies});
        return (JniLibraryNativeDependenciesInternal)this.getObjects().newInstance(JniLibraryNativeDependenciesInternal.class, new Object[]{variantDependencies, incoming});
    }

    public void apply(Project project) {
        IncompatiblePluginUsage.forProject(project).assertPluginIds(IncompatiblePluginsAdvice.SOFTWARE_MODEL_PLUGIN_IDS, IncompatiblePluginsAdvice::forSoftwareModelNativePlugins).assertPluginId("application", IncompatiblePluginsAdvice::forJavaApplicationEntryPointPlugin).assertPluginId("java-library", IncompatiblePluginsAdvice::forJavaLibraryEntryPointPlugin).assertPluginIds(IncompatiblePluginsAdvice.CURRENT_MODEL_PLUGIN_IDS, IncompatiblePluginsAdvice::forCurrentModelNativePlugins).assertPluginClass(NativeBasePlugin.class, IncompatiblePluginsAdvice::forNativeBasePlugin);
        project.getPluginManager().apply("base");
        project.getPluginManager().apply("lifecycle-base");
        project.getPluginManager().apply(StandardToolChainsPlugin.class);
        NamingSchemeFactory namingSchemeFactory = new NamingSchemeFactory(project.getName());
        NamingScheme mainComponentNames = namingSchemeFactory.forMainComponent();
        JniLibraryExtensionInternal extension = this.registerExtension(project, mainComponentNames);
        project.afterEvaluate((Action)this.getObjects().newInstance(TargetMachineRule.class, new Object[]{extension.getTargetMachines(), EXTENSION_NAME}));
        project.getPluginManager().withPlugin("java", appliedPlugin -> this.configureJavaJniRuntime(project, extension));
        project.getPluginManager().withPlugin("java", appliedPlugin -> this.registerJniHeaderSourceSet(project, extension));
        project.getPlugins().withType(NativePlatformCapabilitiesMarkerPlugin.class, appliedPlugin -> project.getPluginManager().apply(DarwinFrameworkResolutionSupportPlugin.class));
        OneTimeLogger unbuildableMainComponentLogger = new OneTimeLogger(new WarnUnbuildableLogger(project.getPath()));
        project.afterEvaluate(proj -> {
            if (proj.getPluginManager().hasPlugin("dev.nokee.cpp-language")) {
                extension.getComponent().getSourceCollection().add((Object)((CppSourceSet)this.getObjects().newInstance(CppSourceSet.class, new Object[0])).srcDir((Object)"src/main/cpp"));
            }
            if (proj.getPluginManager().hasPlugin("dev.nokee.c-language")) {
                extension.getComponent().getSourceCollection().add((Object)((CSourceSet)this.getObjects().newInstance(CSourceSet.class, new Object[0])).srcDir((Object)"src/main/c"));
            }
            if (proj.getPluginManager().hasPlugin("dev.nokee.objective-cpp-language")) {
                extension.getComponent().getSourceCollection().add((Object)((ObjectiveCppSourceSet)this.getObjects().newInstance(ObjectiveCppSourceSet.class, new Object[0])).srcDir((Object)"src/main/objcpp"));
            }
            if (proj.getPluginManager().hasPlugin("dev.nokee.objective-c-language")) {
                extension.getComponent().getSourceCollection().add((Object)((ObjectiveCSourceSet)this.getObjects().newInstance(ObjectiveCSourceSet.class, new Object[0])).srcDir((Object)"src/main/objc"));
            }
            Set targetMachines = (Set)extension.getTargetMachines().get();
            Optional<DefaultJvmJarBinary> jvmJarBinary = this.findJvmBinary((Project)proj);
            ((Set)extension.getBuildVariants().get()).forEach(buildVariant -> {
                DefaultTargetMachine targetMachineInternal = new DefaultTargetMachine((DefaultOperatingSystemFamily)buildVariant.getDimensions().get(0), (DefaultMachineArchitecture)buildVariant.getDimensions().get(1));
                NamingScheme names = mainComponentNames.forBuildVariant(buildVariant, (Collection)extension.getBuildVariants().get());
                JniLibraryNativeDependenciesInternal dependencies = this.newDependencies(names.withComponentDisplayName("JNI shared library"), (BuildVariant)buildVariant, extension.getComponent());
                VariantProvider library = extension.getVariantCollection().registerVariant(buildVariant, (name, bv) -> {
                    JniLibraryInternal it = extension.getComponent().createVariant(name, bv, dependencies);
                    DomainObjectSet objectSourceSets = this.getObjects().domainObjectSet(GeneratedSourceSet.class);
                    if (project.getPlugins().hasPlugin(NativePlatformCapabilitiesMarkerPlugin.class)) {
                        objectSourceSets.addAll((Collection)((NativeLanguageRules)this.getObjects().newInstance(NativeLanguageRules.class, new Object[]{names})).apply(extension.getComponent().getSourceCollection()));
                    }
                    TaskProvider linkTask = this.getTasks().register(names.getTaskName("link"), LinkSharedLibraryTask.class);
                    it.registerSharedLibraryBinary((DomainObjectSet<GeneratedSourceSet>)objectSourceSets, (TaskProvider<LinkSharedLibraryTask>)linkTask, targetMachines.size() > 1, dependencies.getIncoming());
                    if (jvmJarBinary.isPresent() && targetMachines.size() == 1) {
                        it.addJniJarBinary((AbstractJarBinary)jvmJarBinary.get());
                    } else {
                        it.registerJniJarBinary();
                        jvmJarBinary.ifPresent(it::addJvmJarBinary);
                    }
                    return it;
                });
                if (project.getPlugins().hasPlugin(NativePlatformCapabilitiesMarkerPlugin.class)) {
                    this.getTasks().register(names.getTaskName("objects"), task -> {
                        task.setGroup("build");
                        task.setDescription("Assembles main objects.");
                        task.dependsOn(new Object[]{library.map(it -> it.getSharedLibrary().getCompileTasks())});
                    });
                }
                this.getTasks().register(names.getTaskName("sharedLibrary"), task -> {
                    task.setGroup("build");
                    task.setDescription("Assembles a shared library binary containing the main objects.");
                    task.dependsOn(new Object[]{library.map(it -> it.getSharedLibrary().getLinkTask())});
                });
                if (targetMachines.size() > 1) {
                    this.getTasks().register(names.getTaskName("assemble"), task -> {
                        task.setGroup("build");
                        task.setDescription(String.format("Assembles the '%s' outputs of this project.", library.getDelegate().getName()));
                        task.dependsOn(new Object[]{library.map(it -> it.getJar().getJarTask())});
                        task.dependsOn(new Object[]{jvmJarBinary.map(it -> ImmutableList.of(it.getJarTask())).orElse(ImmutableList.of())});
                    });
                }
                if (targetMachines.size() == 1) {
                    if (project.getPluginManager().hasPlugin("java")) {
                        this.getTasks().named("jar", Jar.class, task -> {
                            task.setGroup("build");
                            task.setDescription("Assembles a jar archive containing the main classes and shared library.");
                            this.configureJarTaskUsing((VariantProvider<JniLibraryInternal>)library, unbuildableMainComponentLogger).execute(task);
                        });
                    } else {
                        TaskProvider jarTask = this.getTasks().register("jar", Jar.class, task -> {
                            task.setGroup("build");
                            task.setDescription("Assembles a jar archive containing the shared library.");
                            this.configureJarTaskUsing((VariantProvider<JniLibraryInternal>)library, unbuildableMainComponentLogger).execute(task);
                        });
                        this.getConfigurations().named("runtimeElements", it -> it.getOutgoing().artifact((Object)jarTask.flatMap(AbstractArchiveTask::getArchiveFile)));
                    }
                } else {
                    TaskProvider jarTask = this.getTasks().register(names.getTaskName("jar"), Jar.class, task -> {
                        this.configureJarTaskUsing((VariantProvider<JniLibraryInternal>)library, unbuildableMainComponentLogger).execute(task);
                        task.getArchiveBaseName().set((Object)names.getBaseName().withKababDimensions());
                    });
                    if (this.toolChainSelector.canBuild((TargetMachine)targetMachineInternal)) {
                        this.getConfigurations().named("runtimeElements", it -> it.getOutgoing().artifact((Object)jarTask.flatMap(AbstractArchiveTask::getArchiveFile)));
                    }
                }
                if (DefaultTargetMachine.isTargetingHost().test(targetMachineInternal)) {
                    project.getTasks().named("assemble", it -> it.dependsOn(new Object[]{library.map(l -> l.getJar().getJarTask())}));
                }
            });
            extension.getVariantCollection().disallowChanges();
        });
        project.afterEvaluate(proj -> {
            this.getTasks().named("tasks", task -> task.dependsOn(new Object[]{() -> {
                extension.getVariantCollection().realize();
                return Collections.emptyList();
            }}));
            this.getTasks().named("dependencies", task -> task.dependsOn(new Object[]{() -> {
                extension.getVariantCollection().realize();
                return Collections.emptyList();
            }}));
            this.getTasks().named("outgoingVariants", task -> task.dependsOn(new Object[]{() -> {
                extension.getVariantCollection().realize();
                return Collections.emptyList();
            }}));
        });
        project.afterEvaluate(proj -> project.getConfigurations().addRule("Java Native Interface (JNI) variants are resolved only when needed.", it -> extension.getVariantCollection().realize()));
        this.getTasks().named("assemble", task -> task.dependsOn(new Object[]{() -> {
            boolean targetsCurrentMachine = ((Set)extension.getTargetMachines().get()).stream().anyMatch(arg_0 -> ((ToolChainSelectorInternal)this.toolChainSelector).canBuild(arg_0));
            if (!targetsCurrentMachine) {
                unbuildableMainComponentLogger.log();
            }
            return Collections.emptyList();
        }}));
    }

    private Action<Jar> configureJarTaskUsing(final VariantProvider<JniLibraryInternal> library, PreparedLogger unbuildableMainComponentLogger) {
        return task -> {
            final MissingFileDiagnostic diagnostic = new MissingFileDiagnostic();
            task.doFirst((Action)new Action<Task>(){

                public void execute(Task task) {
                    diagnostic.run(this.warnAboutMissingFiles((Iterable<File>)task.getInputs().getSourceFiles()));
                    diagnostic.logTo(task.getLogger());
                }

                private Consumer<MissingFileDiagnostic> warnAboutMissingFiles(Iterable<File> files) {
                    return diagnostic -> {
                        ImmutableList.Builder builder = ImmutableList.builder();
                        File linkedFile = ((RegularFile)((LinkSharedLibrary)((JniLibraryInternal)library.get()).getSharedLibrary().getLinkTask().get()).getLinkedFile().get()).getAsFile();
                        for (File file : files) {
                            if (file.exists() || file.equals(linkedFile)) continue;
                            builder.add((Object)file);
                        }
                        diagnostic.missingFiles((List<File>)builder.build());
                    };
                }
            });
            task.from((Object)library.map(it -> {
                if (task.getName().equals("jar")) {
                    if (it.getTargetMachine().getOperatingSystemFamily().equals((Object)DefaultOperatingSystemFamily.HOST)) {
                        return it.getNativeRuntimeFiles();
                    }
                    unbuildableMainComponentLogger.log();
                    return Collections.emptyList();
                }
                return it.getNativeRuntimeFiles();
            }), spec -> spec.into((Object)library.map(JniLibrary::getResourcePath)));
        };
    }

    private Optional<DefaultJvmJarBinary> findJvmBinary(Project project) {
        if (project.getPluginManager().hasPlugin("java")) {
            TaskProvider jvmJarTask = project.getTasks().named("jar", Jar.class);
            return Optional.of((DefaultJvmJarBinary)this.getObjects().newInstance(DefaultJvmJarBinary.class, new Object[]{jvmJarTask}));
        }
        return Optional.empty();
    }

    @Inject
    protected abstract ToolChainSelector getToolChainSelector();

    @Inject
    protected abstract ObjectFactory getObjects();

    private static void assertNonEmpty(Collection<?> values, String propertyName, String componentName) {
        if (values.isEmpty()) {
            throw new IllegalArgumentException(String.format("A %s needs to be specified for the %s.", propertyName, componentName));
        }
    }

    private void assertTargetMachinesAreKnown(Collection<TargetMachine> targetMachines) {
        List unknownTargetMachines = targetMachines.stream().filter(it -> !this.toolChainSelector.isKnown(it)).collect(Collectors.toList());
        if (!unknownTargetMachines.isEmpty()) {
            throw new IllegalArgumentException("The following target machines are not know by the defined tool chains:\n" + unknownTargetMachines.stream().map(it -> " * " + ((DefaultOperatingSystemFamily)it.getOperatingSystemFamily()).getName() + " " + ((DefaultMachineArchitecture)it.getArchitecture()).getName()).collect(Collectors.joining("\n")));
        }
    }

    private JniLibraryExtensionInternal registerExtension(Project project, NamingScheme names) {
        Object[] objectArray = new Object[2];
        objectArray[0] = GroupId.of(() -> ((Project)project).getGroup());
        objectArray[1] = names;
        JniLibraryExtensionInternal library = (JniLibraryExtensionInternal)project.getObjects().newInstance(JniLibraryExtensionInternal.class, objectArray);
        JniLibraryDependenciesInternal dependencies = library.getDependencies();
        Configuration jvmApiElements = Optional.ofNullable((Configuration)project.getConfigurations().findByName("apiElements")).orElseGet(() -> (Configuration)project.getConfigurations().create("apiElements", configuration -> {
            ConfigurationUtils.configureAsOutgoing((Configuration)configuration);
            configuration.setDescription("API elements for main.");
            configuration.attributes(attributes -> {
                attributes.attribute(Usage.USAGE_ATTRIBUTE, (Object)((Usage)project.getObjects().named(Usage.class, "java-api")));
                attributes.attribute(LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE, (Object)((LibraryElements)project.getObjects().named(LibraryElements.class, "jar")));
            });
        }));
        jvmApiElements.extendsFrom(new Configuration[]{dependencies.getApiDependencies()});
        Configuration jvmRuntimeElements = Optional.ofNullable((Configuration)project.getConfigurations().findByName("runtimeElements")).orElseGet(() -> (Configuration)project.getConfigurations().create("runtimeElements", configuration -> {
            ConfigurationUtils.configureAsOutgoing((Configuration)configuration);
            configuration.setDescription("Elements of runtime for main.");
            configuration.attributes(attributes -> {
                attributes.attribute(Usage.USAGE_ATTRIBUTE, (Object)((Usage)project.getObjects().named(Usage.class, "java-runtime")));
                attributes.attribute(LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE, (Object)((LibraryElements)project.getObjects().named(LibraryElements.class, "jar")));
            });
        }));
        jvmRuntimeElements.extendsFrom(new Configuration[]{dependencies.getApiDependencies()});
        project.getPluginManager().withPlugin("java", appliedPlugin -> this.getConfigurations().getByName("runtimeOnly").extendsFrom(new Configuration[]{dependencies.getJvmRuntimeOnlyDependencies()}));
        project.getExtensions().add(JniLibraryExtension.class, EXTENSION_NAME, (Object)library);
        return library;
    }

    private static boolean isGradleVersionGreaterOrEqualsTo6Dot3() {
        return GradleVersion.current().compareTo(GradleVersion.version((String)"6.3")) >= 0;
    }

    private void registerJniHeaderSourceSet(Project project, JniLibraryExtensionInternal library) {
        SourceSetContainer sourceSets = (SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class);
        SourceSet main = (SourceSet)sourceSets.getByName("main");
        TaskProvider compileTask = project.getTasks().named(main.getCompileJavaTaskName(), JavaCompile.class, task -> {
            task.getOptions().getHeaderOutputDirectory().convention(project.getLayout().getBuildDirectory().dir("generated/jni-headers"));
            if (!JniLibraryPlugin.isGradleVersionGreaterOrEqualsTo6Dot3()) {
                task.getOutputs().dir((Object)task.getOptions().getHeaderOutputDirectory());
            }
            task.getOptions().setIncremental(JniLibraryPlugin.isGradleVersionGreaterOrEqualsTo6Dot3());
        });
        HeaderExportingSourceSetInternal jniHeaderSourceSet = (HeaderExportingSourceSetInternal)project.getObjects().newInstance(HeaderExportingSourceSetInternal.class, new Object[0]);
        jniHeaderSourceSet.getSource().from(new Object[]{compileTask.flatMap(it -> it.getOptions().getHeaderOutputDirectory())});
        library.getSources().add((Object)jniHeaderSourceSet);
    }

    private void configureJavaJniRuntime(Project project, JniLibraryExtensionInternal library) {
        project.getConfigurations().getByName("implementation").extendsFrom(new Configuration[]{library.getJvmImplementationDependencies()});
        project.getTasks().named("test", Test.class, task -> {
            final Provider files = library.getVariants().map(JniLibrary::getNativeRuntimeFiles);
            task.dependsOn(new Object[]{() -> {
                JniLibraryInternal variant = (JniLibraryInternal)library.getComponent().getDevelopmentVariant().getOrNull();
                if (variant == null) {
                    return Collections.emptyList();
                }
                return variant.getNativeRuntimeFiles();
            }});
            task.getJvmArgumentProviders().add(new CommandLineArgumentProvider(){

                public Iterable<String> asArguments() {
                    String path = ((List)files.get()).stream().flatMap(it -> it.getFiles().stream()).map(it -> it.getParentFile().getAbsolutePath()).collect(Collectors.joining(File.pathSeparator));
                    return ImmutableList.of((Object)("-Djava.library.path=" + path));
                }
            });
        });
    }

    static abstract class IncompatiblePluginsAdvice {
        static final Set<String> SOFTWARE_MODEL_PLUGIN_IDS = ImmutableSet.of((Object)"cpp", (Object)"cpp-lang", (Object)"c", (Object)"c-lang", (Object)"objective-c", (Object)"objective-c-lang", (Object[])new String[]{"objective-cpp", "objective-cpp-lang"});
        static final Set<String> CURRENT_MODEL_PLUGIN_IDS = ImmutableSet.of((Object)"cpp-library", (Object)"cpp-application", (Object)"swift-library", (Object)"swift-application");
        static final String JAVA_APPLICATION_PLUGIN_ID = "application";
        static final String JAVA_LIBRARY_PLUGIN_ID = "java-library";
        private static final String SOFTWARE_MODEL_MIGRATION = "To learn more about software model migration, visit https://nokee.dev/docs/migrating-from-software-model";
        private static final String CURRENT_MODEL_MIGRATION = "To learn more about Gradle core native plugin migration, visit https://nokee.dev/docs/migrating-from-core-plugins";
        private static final String PROJECT_ENTRY_POINT = "To learn more about project entry points, visit https://nokee.dev/docs/project-entry-points";
        private static final String LEARN_CPP_LANGUAGE = "To learn more about 'dev.nokee.cpp-language' plugin, visit https://nokee.dev/docs/cpp-language-plugin";
        private static final String USE_CPP_LANGUAGE = "Use 'dev.nokee.cpp-language' plugin instead of the 'cpp-application' and 'cpp-library' plugins";
        private static final String VOTE_SWIFT_LANGUAGE = "Vote on https://github.com/nokeedev/gradle-native/issues/26 issue to show interest for Swift language support";
        private static final String REMOTE_SWIFT_PLUGINS = "Remove 'swift-application' and 'swift-library' plugins from the project";

        IncompatiblePluginsAdvice() {
        }

        static void forJavaApplicationEntryPointPlugin(String pluginId, IncompatiblePluginUsage.Context context) {
            context.advice("Refer to https://nokee.dev/docs/building-jni-application for learning how to build JNI application").withFootnote(PROJECT_ENTRY_POINT);
        }

        static void forJavaLibraryEntryPointPlugin(String pluginId, IncompatiblePluginUsage.Context context) {
            context.advice("Use 'java' plugin instead of 'java-library' plugin").withFootnote(PROJECT_ENTRY_POINT);
        }

        static void forSoftwareModelNativePlugins(String pluginId, IncompatiblePluginUsage.Context context) {
            switch (pluginId) {
                case "cpp": 
                case "cpp-lang": {
                    context.advice("Use 'dev.nokee.cpp-language' plugin instead of the 'cpp' and 'cpp-lang' plugins").withFootnote(LEARN_CPP_LANGUAGE).withFootnote(SOFTWARE_MODEL_MIGRATION);
                    break;
                }
                case "c": 
                case "c-lang": {
                    context.advice("Use 'dev.nokee.c-language' plugin instead of the 'c' and 'c-lang' plugins").withFootnote("To learn more about 'dev.nokee.c-language' plugin, visit https://nokee.dev/docs/c-language-plugin").withFootnote(SOFTWARE_MODEL_MIGRATION);
                    break;
                }
                case "objective-c": 
                case "objective-c-lang": {
                    context.advice("Use 'dev.nokee.objective-c-language' plugin instead of the 'objective-c' and 'objective-c-lang' plugins").withFootnote("To learn more about 'dev.nokee.objective-c-language' plugin, visit https://nokee.dev/docs/objective-c-language-plugin").withFootnote(SOFTWARE_MODEL_MIGRATION);
                    break;
                }
                case "objective-cpp": 
                case "objective-cpp-lang": {
                    context.advice("Use 'dev.nokee.objective-cpp-language' plugin instead of the 'objective-cpp' and 'objective-cpp-lang' plugins").withFootnote("To learn more about 'dev.nokee.objective-cpp-language' plugin, visit https://nokee.dev/docs/objective-cpp-language-plugin").withFootnote(SOFTWARE_MODEL_MIGRATION);
                }
            }
        }

        static void forCurrentModelNativePlugins(String pluginId, IncompatiblePluginUsage.Context context) {
            switch (pluginId) {
                case "cpp-application": 
                case "cpp-library": {
                    context.advice(USE_CPP_LANGUAGE).withFootnote(LEARN_CPP_LANGUAGE).withFootnote(PROJECT_ENTRY_POINT).withFootnote(CURRENT_MODEL_MIGRATION);
                    break;
                }
                case "swift-application": 
                case "swift-library": {
                    context.advice(REMOTE_SWIFT_PLUGINS).withFootnote(PROJECT_ENTRY_POINT);
                    context.advice(VOTE_SWIFT_LANGUAGE);
                }
            }
        }

        static void forNativeBasePlugin(String pluginId, IncompatiblePluginUsage.Context context) {
            context.advice(USE_CPP_LANGUAGE).withFootnote(LEARN_CPP_LANGUAGE).withFootnote(PROJECT_ENTRY_POINT).withFootnote(CURRENT_MODEL_MIGRATION);
            context.advice(REMOTE_SWIFT_PLUGINS).withFootnote(PROJECT_ENTRY_POINT);
            context.advice(VOTE_SWIFT_LANGUAGE);
        }
    }

    private static class OneTimeLogger
    implements PreparedLogger {
        private final PreparedLogger delegate;
        private boolean messageAlreadyLogged = false;

        @Override
        public void log() {
            if (!this.messageAlreadyLogged) {
                this.delegate.log();
                this.messageAlreadyLogged = true;
            }
        }

        public OneTimeLogger(PreparedLogger delegate) {
            this.delegate = delegate;
        }
    }

    private static class WarnUnbuildableLogger
    implements PreparedLogger {
        private static final Logger LOGGER = Logging.getLogger(WarnUnbuildableLogger.class);
        private final String projectPath;

        @Override
        public void log() {
            LOGGER.warn("'main' component in project '" + this.projectPath + "' cannot build on this machine.");
        }

        public WarnUnbuildableLogger(String projectPath) {
            this.projectPath = projectPath;
        }
    }

    private static interface PreparedLogger {
        public void log();
    }

    private static class MissingFileDiagnostic {
        private boolean hasAlreadyRan = false;
        private final List<File> missingFiles = new ArrayList<File>();

        private MissingFileDiagnostic() {
        }

        public void logTo(Logger logger) {
            if (!this.missingFiles.isEmpty()) {
                StringBuilder builder = new StringBuilder();
                builder.append("The following file");
                if (this.missingFiles.size() > 1) {
                    builder.append("s are");
                } else {
                    builder.append(" is");
                }
                builder.append(" missing and will be absent from the JAR file:").append(System.lineSeparator());
                for (File file : this.missingFiles) {
                    builder.append(" * ").append(file.getPath()).append(System.lineSeparator());
                }
                builder.append("We recommend taking the following actions:").append(System.lineSeparator());
                builder.append(" - Verify 'nativeRuntimeFile' property configuration for each variants").append(System.lineSeparator());
                builder.append("Missing files from the JAR file can lead to runtime errors such as 'NoClassDefFoundError'.");
                logger.warn(builder.toString());
            }
        }

        public void missingFiles(List<File> missingFiles) {
            this.missingFiles.addAll(missingFiles);
        }

        public void run(Consumer<MissingFileDiagnostic> action) {
            if (!this.hasAlreadyRan) {
                action.accept(this);
                this.hasAlreadyRan = false;
            }
        }
    }
}

