/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.platform.jni.internal;

import dev.nokee.language.base.internal.GeneratedSourceSet;
import dev.nokee.language.base.internal.LanguageSourceSetInternal;
import dev.nokee.platform.base.Binary;
import dev.nokee.platform.base.internal.BaseVariant;
import dev.nokee.platform.base.internal.BuildVariant;
import dev.nokee.platform.base.internal.GroupId;
import dev.nokee.platform.base.internal.NamingScheme;
import dev.nokee.platform.jni.JniLibrary;
import dev.nokee.platform.jni.JniLibraryNativeDependencies;
import dev.nokee.platform.jni.internal.AbstractJarBinary;
import dev.nokee.platform.jni.internal.DefaultJniJarBinary;
import dev.nokee.platform.jni.internal.DefaultJvmJarBinary;
import dev.nokee.platform.jni.internal.JniLibraryNativeDependenciesInternal;
import dev.nokee.platform.nativebase.SharedLibraryBinary;
import dev.nokee.platform.nativebase.internal.SharedLibraryBinaryInternal;
import dev.nokee.platform.nativebase.internal.dependencies.NativeIncomingDependencies;
import dev.nokee.platform.nativebase.tasks.internal.LinkSharedLibraryTask;
import dev.nokee.runtime.nativebase.internal.DefaultMachineArchitecture;
import dev.nokee.runtime.nativebase.internal.DefaultOperatingSystemFamily;
import dev.nokee.runtime.nativebase.internal.DefaultTargetMachine;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.Task;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.jvm.tasks.Jar;
import org.gradle.nativeplatform.tasks.AbstractLinkTask;

public abstract class JniLibraryInternal
extends BaseVariant
implements JniLibrary {
    private final NamingScheme names;
    private final JniLibraryNativeDependenciesInternal dependencies;
    private final DomainObjectSet<LanguageSourceSetInternal> sources;
    private final DefaultTargetMachine targetMachine;
    private final GroupId groupId;
    private AbstractJarBinary jarBinary;
    private SharedLibraryBinaryInternal sharedLibraryBinary;

    @Inject
    public JniLibraryInternal(String name, NamingScheme names, DomainObjectSet<LanguageSourceSetInternal> parentSources, BuildVariant buildVariant, GroupId groupId, DomainObjectSet<Binary> parentBinaries, JniLibraryNativeDependenciesInternal dependencies) {
        super(name, buildVariant);
        this.names = names;
        this.dependencies = dependencies;
        this.sources = this.getObjects().domainObjectSet(LanguageSourceSetInternal.class);
        this.targetMachine = new DefaultTargetMachine((DefaultOperatingSystemFamily)buildVariant.getDimensions().get(0), (DefaultMachineArchitecture)buildVariant.getDimensions().get(1));
        this.groupId = groupId;
        parentSources.all(arg_0 -> this.sources.add(arg_0));
        this.getBinaryCollection().configureEach(arg_0 -> parentBinaries.add(arg_0));
        this.getResourcePath().convention(this.getProviders().provider(() -> names.getResourcePath(groupId)));
    }

    public DomainObjectSet<LanguageSourceSetInternal> getSources() {
        return this.sources;
    }

    @Inject
    protected abstract ConfigurationContainer getConfigurations();

    @Inject
    protected abstract ProviderFactory getProviders();

    @Inject
    protected abstract TaskContainer getTasks();

    public void registerSharedLibraryBinary(DomainObjectSet<GeneratedSourceSet> objectSourceSets, TaskProvider<LinkSharedLibraryTask> linkTask, boolean multipleVariants, NativeIncomingDependencies dependencies) {
        SharedLibraryBinaryInternal sharedLibraryBinary = (SharedLibraryBinaryInternal)this.getObjects().newInstance(SharedLibraryBinaryInternal.class, new Object[]{this.names, this.sources, this.targetMachine, objectSourceSets, linkTask, dependencies});
        this.getNativeRuntimeFiles().from(new Object[]{linkTask.flatMap(AbstractLinkTask::getLinkedFile)});
        this.getNativeRuntimeFiles().from(new Object[]{sharedLibraryBinary.getRuntimeLibrariesDependencies()});
        this.sharedLibraryBinary = sharedLibraryBinary;
        sharedLibraryBinary.getBaseName().convention((Object)this.names.getBaseName().getAsString());
        this.getBinaryCollection().add((Object)sharedLibraryBinary);
    }

    public void registerJniJarBinary() {
        TaskProvider jarTask = this.getTasks().named(this.names.getTaskName("jar"), Jar.class);
        this.addJniJarBinary((AbstractJarBinary)this.getObjects().newInstance(DefaultJniJarBinary.class, new Object[]{jarTask}));
    }

    public AbstractJarBinary getJar() {
        return this.jarBinary;
    }

    public SharedLibraryBinaryInternal getSharedLibrary() {
        return this.sharedLibraryBinary;
    }

    @Override
    public void sharedLibrary(Action<? super SharedLibraryBinary> action) {
        action.execute((Object)this.sharedLibraryBinary);
    }

    public void addJniJarBinary(AbstractJarBinary jniJarBinary) {
        this.jarBinary = jniJarBinary;
        this.getBinaryCollection().add((Object)jniJarBinary);
    }

    public void addJvmJarBinary(DefaultJvmJarBinary jvmJarBinary) {
        this.getBinaryCollection().add((Object)jvmJarBinary);
    }

    public DefaultTargetMachine getTargetMachine() {
        return this.targetMachine;
    }

    public TaskProvider<Task> getAssembleTask() {
        return this.getTasks().named(this.names.getTaskName("assemble"));
    }

    public JniLibraryNativeDependencies getDependencies() {
        return this.dependencies;
    }

    public void dependencies(Action<? super JniLibraryNativeDependencies> action) {
        action.execute((Object)this.dependencies);
    }
}

