/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.platform.jni.internal;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.plugins.PluginManager;

public class IncompatiblePluginUsage {
    private final Project project;

    public static IncompatiblePluginUsage forProject(Project project) {
        return new IncompatiblePluginUsage(project);
    }

    public IncompatiblePluginUsage assertPluginIds(Set<String> incompatiblePluginIds, AdviceRepository recommendationRepository) {
        Set<String> appliedIncompatiblePluginIds = incompatiblePluginIds.stream().filter(arg_0 -> ((PluginManager)this.project.getPluginManager()).hasPlugin(arg_0)).collect(Collectors.toSet());
        if (!appliedIncompatiblePluginIds.isEmpty()) {
            throw new GradleException(new IncompatiblePluginUsageMessageBuilder().inProject(this.project).withIncompatiblePluginIds(appliedIncompatiblePluginIds).withRecommendation(recommendationRepository).build());
        }
        incompatiblePluginIds.forEach(pluginId -> this.project.getPluginManager().withPlugin(pluginId, appliedPlugin -> {
            throw new GradleException(new IncompatiblePluginUsageMessageBuilder().inProject(this.project).withIncompatiblePluginId(appliedPlugin.getId()).withRecommendation(recommendationRepository).build());
        }));
        return this;
    }

    public IncompatiblePluginUsage assertPluginId(String pluginId, AdviceRepository recommendationRepository) {
        this.project.getPluginManager().withPlugin(pluginId, appliedPlugin -> {
            throw new GradleException(new IncompatiblePluginUsageMessageBuilder().inProject(this.project).withIncompatiblePluginId(pluginId).withRecommendation(recommendationRepository).build());
        });
        return this;
    }

    public IncompatiblePluginUsage assertPluginClass(Class<? extends Plugin<?>> pluginClass, AdviceRepository recommendationRepository) {
        this.project.getPlugins().withType(pluginClass, appliedPlugin -> {
            throw new GradleException(new IncompatiblePluginUsageMessageBuilder().inProject(this.project).withIncompatiblePluginId(pluginClass.getCanonicalName()).withRecommendation(recommendationRepository).build());
        });
        return this;
    }

    public IncompatiblePluginUsage(Project project) {
        this.project = project;
    }

    public static interface AdviceBuilder {
        public AdviceBuilder withFootnote(String var1);
    }

    public static interface Context {
        public AdviceBuilder advice(String var1);
    }

    private static class Advice {
        private final String advice;
        private final List<Footnote> footnotes = new ArrayList<Footnote>();

        public Advice linkToFootnote(Footnote footnote) {
            this.footnotes.add(footnote);
            return this;
        }

        public String asAdvice() {
            if (this.footnotes.isEmpty()) {
                return this.advice;
            }
            return this.advice + " " + this.footnotes.stream().map(Footnote::asReference).collect(Collectors.joining());
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Advice)) {
                return false;
            }
            Advice other = (Advice)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$advice = this.advice;
            String other$advice = other.advice;
            return !(this$advice == null ? other$advice != null : !this$advice.equals(other$advice));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Advice;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $advice = this.advice;
            result = result * 59 + ($advice == null ? 43 : $advice.hashCode());
            return result;
        }

        public Advice(String advice) {
            this.advice = advice;
        }
    }

    private static class Footnote {
        private final int number;
        private final String footnote;

        public String asReference() {
            return "[" + this.number + "]";
        }

        public String asFootnote() {
            return this.asReference() + " " + this.footnote;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Footnote)) {
                return false;
            }
            Footnote other = (Footnote)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.number != other.number) {
                return false;
            }
            String this$footnote = this.footnote;
            String other$footnote = other.footnote;
            return !(this$footnote == null ? other$footnote != null : !this$footnote.equals(other$footnote));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Footnote;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.number;
            String $footnote = this.footnote;
            result = result * 59 + ($footnote == null ? 43 : $footnote.hashCode());
            return result;
        }

        public Footnote(int number, String footnote) {
            this.number = number;
            this.footnote = footnote;
        }
    }

    public static class IncompatiblePluginUsageMessageBuilder {
        private List<String> incompatiblePluginIds;
        private String projectPath;
        private AdviceRepository recommendation;

        public IncompatiblePluginUsageMessageBuilder withIncompatiblePluginIds(Iterable<String> incompatiblePluginIds) {
            this.incompatiblePluginIds = ImmutableList.copyOf(incompatiblePluginIds);
            return this;
        }

        public IncompatiblePluginUsageMessageBuilder withIncompatiblePluginId(String incompatiblePluginId) {
            this.incompatiblePluginIds = ImmutableList.of((Object)incompatiblePluginId);
            return this;
        }

        public IncompatiblePluginUsageMessageBuilder withRecommendation(AdviceRepository recommendation) {
            this.recommendation = recommendation;
            return this;
        }

        public IncompatiblePluginUsageMessageBuilder inProject(Project project) {
            this.projectPath = project.getPath();
            return this;
        }

        public String build() {
            StringBuilder builder = new StringBuilder();
            builder.append("Nokee detected the usage of incompatible plugins in the project '").append(this.projectPath).append("'.\n");
            final LinkedHashSet advices = new LinkedHashSet();
            final ArrayList footnotes = new ArrayList();
            Context context = new Context(){

                @Override
                public AdviceBuilder advice(String message) {
                    final Advice advice = new Advice(message);
                    advices.add(advice);
                    return new AdviceBuilder(){

                        @Override
                        public AdviceBuilder withFootnote(String note) {
                            advice.linkToFootnote(footnotes.stream().filter(it -> ((Footnote)it).footnote.equals(note)).findFirst().orElseGet(() -> {
                                Footnote footnote = new Footnote(footnotes.size() + 1, note);
                                footnotes.add(footnote);
                                return footnote;
                            }));
                            return this;
                        }
                    };
                }
            };
            this.incompatiblePluginIds.forEach(it -> this.recommendation.findAdvice((String)it, context));
            builder.append("We recommend taking the following ");
            if (advices.size() == 1) {
                builder.append("action");
            } else {
                builder.append("actions");
            }
            builder.append(":\n");
            advices.stream().forEach(it -> builder.append(" * ").append(it.asAdvice()).append("\n"));
            builder.append("\nTo learn more, visit https://nokee.dev/docs/incompatible-plugins");
            if (!footnotes.isEmpty()) {
                builder.append("\n\n");
                for (Footnote it2 : footnotes) {
                    builder.append(it2.asFootnote()).append("\n");
                }
            }
            return builder.toString();
        }
    }

    public static interface AdviceRepository {
        public void findAdvice(String var1, Context var2);
    }
}

