/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.platform.jni.internal.plugins;

import dev.nokee.platform.jni.JniLibraryExtension;
import dev.nokee.platform.jni.internal.JniLibraryExtensionInternal;
import dev.nokee.platform.nativebase.TargetMachine;
import dev.nokee.platform.nativebase.internal.NativePlatformFactory;
import dev.nokee.platform.nativebase.internal.SharedLibraryBinaryInternal;
import dev.nokee.platform.nativebase.internal.ToolChainSelectorInternal;
import java.util.Collection;
import java.util.Set;
import org.codehaus.groovy.runtime.MetaClassHelper;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.internal.project.ProjectIdentifier;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.model.Finalize;
import org.gradle.model.Model;
import org.gradle.model.Mutate;
import org.gradle.model.Path;
import org.gradle.model.RuleSource;
import org.gradle.nativeplatform.NativeLibrarySpec;
import org.gradle.nativeplatform.SharedLibraryBinarySpec;
import org.gradle.nativeplatform.StaticLibraryBinarySpec;
import org.gradle.nativeplatform.tasks.LinkSharedLibrary;
import org.gradle.platform.base.ComponentSpecContainer;
import org.gradle.platform.base.PlatformContainer;
import org.gradle.platform.base.internal.BinarySpecInternal;

public class JniLibraryRules
extends RuleSource {
    @Model
    public JniLibraryExtensionInternal library(ProjectIdentifier projectIdentifier) {
        Project project = (Project)projectIdentifier;
        ExtensionContainer extensions = project.getExtensions();
        return (JniLibraryExtensionInternal)extensions.getByType(JniLibraryExtension.class);
    }

    @Mutate
    public void createNativeLibrary(ComponentSpecContainer components, ProjectIdentifier projectIdentifier) {
        components.create("main", NativeLibrarySpec.class, library -> {
            library.setBaseName(projectIdentifier.getName());
            library.getBinaries().withType(StaticLibraryBinarySpec.class, binary -> ((BinarySpecInternal)binary).setBuildable(false));
        });
    }

    @Mutate
    public void configureTargetMachines(PlatformContainer platforms, JniLibraryExtensionInternal extension) {
        NativePlatformFactory nativePlatformFactory = new NativePlatformFactory();
        ((Set)extension.getTargetMachines().get()).stream().forEach(targetMachine -> platforms.add((Object)nativePlatformFactory.create(targetMachine)));
    }

    @Mutate
    public void configureLibraryTargetMachines(@Path(value="components.main") NativeLibrarySpec library, JniLibraryExtensionInternal extension, ProjectIdentifier projectIdentifier) {
        ToolChainSelectorInternal toolChainSelector = (ToolChainSelectorInternal)((Project)projectIdentifier).getObjects().newInstance(ToolChainSelectorInternal.class, new Object[0]);
        ((Set)extension.getTargetMachines().get()).stream().forEach(targetMachine -> library.targetPlatform(NativePlatformFactory.platformNameFor((TargetMachine)targetMachine)));
    }

    @Finalize
    public void hideSoftwareModelTasks(TaskContainer tasks, @Path(value="components.main") NativeLibrarySpec library) {
        Action hideTask = task -> task.setGroup(null);
        library.getBinaries().values().forEach(binary -> {
            binary.getTasks().all(hideTask);
            hideTask.execute((Object)binary.getTasks().getBuild());
        });
        tasks.named("assembleDependents" + MetaClassHelper.capitalize((String)library.getName()), hideTask);
        tasks.named("buildDependents" + MetaClassHelper.capitalize((String)library.getName()), hideTask);
        tasks.named("components", hideTask);
        tasks.named("dependentComponents", hideTask);
    }

    @Mutate
    public void configureJniLibrary(TaskContainer tasks, @Path(value="components.main") NativeLibrarySpec nativeLibrary, JniLibraryExtensionInternal extension) {
        Collection binaries = nativeLibrary.getBinaries().withType(SharedLibraryBinarySpec.class).values();
        extension.getVariantCollection().forEach(library -> {
            SharedLibraryBinarySpec binary = binaries.stream().filter(it -> NativePlatformFactory.platformNameFor((TargetMachine)library.getTargetMachine()).equals(it.getTargetPlatform().getName())).findFirst().orElseThrow(() -> new RuntimeException("No binary available"));
            SharedLibraryBinaryInternal sharedLibrary = library.getSharedLibrary();
            sharedLibrary.configureSoftwareModelBinary(binary);
            sharedLibrary.getLinkedFile().set((Provider)((LinkSharedLibrary)binary.getTasks().getLink()).getLinkedFile());
            sharedLibrary.getLinkedFile().disallowChanges();
        });
    }
}

