/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.platform.jni.internal;

import com.google.common.collect.ImmutableList;
import dev.nokee.language.base.internal.LanguageSourceSetInternal;
import dev.nokee.platform.base.Binary;
import dev.nokee.platform.base.BinaryView;
import dev.nokee.platform.base.internal.BinaryInternal;
import dev.nokee.platform.base.internal.DefaultBinaryView;
import dev.nokee.platform.base.internal.GroupId;
import dev.nokee.platform.base.internal.NamingScheme;
import dev.nokee.platform.base.internal.TaskUtils;
import dev.nokee.platform.jni.JniLibrary;
import dev.nokee.platform.jni.internal.AbstractJarBinary;
import dev.nokee.platform.jni.internal.DefaultJniJarBinary;
import dev.nokee.platform.jni.internal.DefaultJvmJarBinary;
import dev.nokee.platform.nativebase.SharedLibraryBinary;
import dev.nokee.platform.nativebase.internal.ConfigurationUtils;
import dev.nokee.platform.nativebase.internal.DefaultTargetMachine;
import dev.nokee.platform.nativebase.internal.SharedLibraryBinaryInternal;
import java.util.ArrayList;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.internal.Cast;
import org.gradle.jvm.tasks.Jar;

public abstract class JniLibraryInternal
implements JniLibrary {
    private final NamingScheme names;
    private final DomainObjectSet<BinaryInternal> binaryCollection;
    private final DomainObjectSet<? super LanguageSourceSetInternal> sources;
    private final Configuration implementation;
    private final DefaultTargetMachine targetMachine;
    private final GroupId groupId;
    private final ConfigurationContainer configurations;
    private final Configuration nativeRuntime;
    private AbstractJarBinary jarBinary;
    private SharedLibraryBinaryInternal sharedLibraryBinary;
    private final TaskProvider<Task> assembleTask;

    @Inject
    public JniLibraryInternal(TaskContainer tasks, NamingScheme names, ObjectFactory objectFactory, ProviderFactory providers, ConfigurationContainer configurations, DomainObjectSet<? super LanguageSourceSetInternal> sources, Configuration implementation, DefaultTargetMachine targetMachine, GroupId groupId, DomainObjectSet<BinaryInternal> parentBinaries) {
        this.names = names;
        this.binaryCollection = objectFactory.domainObjectSet(BinaryInternal.class);
        this.configurations = configurations;
        this.sources = sources;
        this.implementation = implementation;
        this.targetMachine = targetMachine;
        this.groupId = groupId;
        this.binaryCollection.configureEach(binary -> parentBinaries.add(binary));
        ConfigurationUtils configurationUtils = (ConfigurationUtils)objectFactory.newInstance(ConfigurationUtils.class, new Object[0]);
        this.nativeRuntime = (Configuration)configurations.create(names.getConfigurationName("nativeRuntime"), (Action)configurationUtils.asIncomingRuntimeLibrariesFrom(implementation).forTargetMachine(targetMachine).asDebug());
        this.getNativeRuntimeFiles().from(new Object[]{this.nativeRuntime});
        this.getResourcePath().convention(providers.provider(() -> names.getResourcePath(groupId)));
        this.assembleTask = this.registerAssembleTaskIfAbsent(tasks);
        this.assembleTask.configure(task -> task.dependsOn(new Object[]{() -> {
            ArrayList<Object> result = new ArrayList<Object>();
            result.add(this.sharedLibraryBinary.getLinkTask());
            result.add(this.jarBinary.getJarTask());
            return result;
        }}));
    }

    private TaskProvider<Task> registerAssembleTaskIfAbsent(TaskContainer tasks) {
        String assembleTaskName = this.names.getTaskName("assemble");
        if (assembleTaskName.equals("assemble")) {
            return tasks.named(assembleTaskName);
        }
        return tasks.register(assembleTaskName);
    }

    @Inject
    protected abstract ObjectFactory getObjectFactory();

    @Inject
    protected abstract TaskContainer getTasks();

    @Override
    public BinaryView<Binary> getBinaries() {
        return (BinaryView)Cast.uncheckedCast((Object)this.getObjectFactory().newInstance(DefaultBinaryView.class, new Object[]{this.binaryCollection}));
    }

    public void registerSharedLibraryBinary() {
        SharedLibraryBinaryInternal sharedLibraryBinary = (SharedLibraryBinaryInternal)this.getObjectFactory().newInstance(SharedLibraryBinaryInternal.class, new Object[]{this.names, this.configurations, this.sources, this.implementation, this.targetMachine});
        this.getNativeRuntimeFiles().from(new Object[]{() -> {
            if (sharedLibraryBinary.getLinkedFile().isPresent()) {
                return ImmutableList.of((Object)sharedLibraryBinary.getLinkedFile());
            }
            return ImmutableList.of();
        }});
        this.sharedLibraryBinary = sharedLibraryBinary;
        this.binaryCollection.add((Object)sharedLibraryBinary);
        this.assembleTask.configure(TaskUtils.dependsOn((Object[])new Object[]{sharedLibraryBinary.getLinkTask()}));
    }

    public void registerJniJarBinary() {
        TaskProvider jarTask = this.getTasks().register(this.names.getTaskName("jar"), Jar.class, task -> task.getArchiveBaseName().set((Object)this.names.getBaseName().withKababDimensions()));
        this.addJniJarBinary((AbstractJarBinary)((Object)this.getObjectFactory().newInstance(DefaultJniJarBinary.class, new Object[]{jarTask})));
    }

    public AbstractJarBinary getJar() {
        return this.jarBinary;
    }

    public SharedLibraryBinaryInternal getSharedLibrary() {
        return this.sharedLibraryBinary;
    }

    @Override
    public void sharedLibrary(Action<? super SharedLibraryBinary> action) {
        action.execute((Object)this.sharedLibraryBinary);
    }

    public FileCollection getNativeRuntimeDependencies() {
        return this.nativeRuntime;
    }

    public abstract ConfigurableFileCollection getNativeRuntimeFiles();

    public void addJniJarBinary(AbstractJarBinary jniJarBinary) {
        this.jarBinary = jniJarBinary;
        this.binaryCollection.add((Object)jniJarBinary);
        this.assembleTask.configure(TaskUtils.dependsOn((Object[])new Object[]{jniJarBinary.getJarTask()}));
    }

    public void addJvmJarBinary(DefaultJvmJarBinary jvmJarBinary) {
        this.binaryCollection.add((Object)jvmJarBinary);
        this.assembleTask.configure(TaskUtils.dependsOn((Object[])new Object[]{jvmJarBinary.getJarTask()}));
    }

    public DefaultTargetMachine getTargetMachine() {
        return this.targetMachine;
    }

    public TaskProvider<Task> getAssembleTask() {
        return this.assembleTask;
    }
}

