/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.platform.jni.internal;

import dev.nokee.language.base.internal.LanguageSourceSetInternal;
import dev.nokee.platform.base.Binary;
import dev.nokee.platform.base.BinaryView;
import dev.nokee.platform.base.VariantView;
import dev.nokee.platform.base.internal.BinaryInternal;
import dev.nokee.platform.base.internal.DefaultBinaryView;
import dev.nokee.platform.base.internal.DefaultVariantView;
import dev.nokee.platform.base.internal.GroupId;
import dev.nokee.platform.base.internal.NamingScheme;
import dev.nokee.platform.jni.JniLibrary;
import dev.nokee.platform.jni.JniLibraryDependencies;
import dev.nokee.platform.jni.JniLibraryExtension;
import dev.nokee.platform.jni.internal.JniLibraryDependenciesInternal;
import dev.nokee.platform.jni.internal.JniLibraryInternal;
import dev.nokee.platform.nativebase.TargetMachine;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.SetProperty;
import org.gradle.internal.Cast;

public abstract class JniLibraryExtensionInternal
implements JniLibraryExtension {
    private final DomainObjectSet<LanguageSourceSetInternal> sources;
    private final ConfigurationContainer configurations;
    private final JniLibraryDependenciesInternal dependencies;
    private final GroupId groupId;
    private final DomainObjectSet<BinaryInternal> binaryCollection;
    private final DomainObjectSet<JniLibraryInternal> variantCollection;

    public DomainObjectSet<JniLibraryInternal> getVariantCollection() {
        return this.variantCollection;
    }

    @Inject
    public JniLibraryExtensionInternal(ObjectFactory objectFactory, ConfigurationContainer configurations, JniLibraryDependenciesInternal dependencies, GroupId groupId) {
        this.binaryCollection = objectFactory.domainObjectSet(BinaryInternal.class);
        this.sources = objectFactory.domainObjectSet(LanguageSourceSetInternal.class);
        this.variantCollection = objectFactory.domainObjectSet(JniLibraryInternal.class);
        this.configurations = configurations;
        this.dependencies = dependencies;
        this.groupId = groupId;
    }

    @Inject
    protected abstract ObjectFactory getObjectFactory();

    public JniLibraryInternal newVariant(NamingScheme names, TargetMachine targetMachine) {
        return (JniLibraryInternal)this.getObjectFactory().newInstance(JniLibraryInternal.class, new Object[]{names, this.configurations, this.sources, this.dependencies.getNativeDependencies(), targetMachine, this.groupId, this.binaryCollection});
    }

    @Override
    public BinaryView<Binary> getBinaries() {
        return (BinaryView)Cast.uncheckedCast((Object)this.getObjectFactory().newInstance(DefaultBinaryView.class, new Object[]{this.binaryCollection}));
    }

    @Override
    public VariantView<JniLibrary> getVariants() {
        return (VariantView)Cast.uncheckedCast((Object)this.getObjectFactory().newInstance(DefaultVariantView.class, new Object[]{this.variantCollection}));
    }

    public DomainObjectSet<LanguageSourceSetInternal> getSources() {
        return this.sources;
    }

    public Configuration getNativeImplementationDependencies() {
        return this.dependencies.getNativeDependencies();
    }

    public Configuration getJvmImplementationDependencies() {
        return this.dependencies.getJvmDependencies();
    }

    @Override
    public JniLibraryDependencies getDependencies() {
        return this.dependencies;
    }

    @Override
    public void dependencies(Action<? super JniLibraryDependencies> action) {
        action.execute((Object)this.dependencies);
    }

    @Override
    public abstract SetProperty<TargetMachine> getTargetMachines();
}

