/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.platform.jni.internal;

import dev.nokee.platform.jni.JniLibraryDependencies;
import dev.nokee.platform.nativebase.internal.ArtifactSerializationTypes;
import dev.nokee.platform.nativebase.internal.LibraryElements;
import java.util.Map;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.model.ObjectFactory;

public abstract class JniLibraryDependenciesInternal
implements JniLibraryDependencies {
    private final Configuration apiDependencies;
    private final Configuration jvmImplementationDependencies;
    private final Configuration nativeImplementationDependencies;

    @Inject
    public JniLibraryDependenciesInternal(ConfigurationContainer configurations) {
        Configuration api = (Configuration)configurations.findByName("api");
        this.apiDependencies = api == null ? (Configuration)configurations.create("api", JniLibraryDependenciesInternal::bucket) : api;
        this.jvmImplementationDependencies = (Configuration)configurations.create("jvmImplementation", JniLibraryDependenciesInternal::bucket);
        this.nativeImplementationDependencies = (Configuration)configurations.create("nativeImplementation", JniLibraryDependenciesInternal::bucket);
        this.jvmImplementationDependencies.extendsFrom(new Configuration[]{this.apiDependencies});
    }

    private static void bucket(Configuration configuration) {
        configuration.setCanBeConsumed(false);
        configuration.setCanBeResolved(false);
    }

    @Inject
    protected abstract DependencyHandler getDependencyHandler();

    @Inject
    protected abstract ObjectFactory getObjects();

    @Override
    public void api(Object notation) {
        this.apiDependencies.getDependencies().add((Object)this.getDependencyHandler().create(notation));
    }

    @Override
    public void api(Object notation, Action<? super ExternalModuleDependency> action) {
        ExternalModuleDependency dependency = (ExternalModuleDependency)this.getDependencyHandler().create(notation);
        action.execute((Object)dependency);
        this.apiDependencies.getDependencies().add((Object)dependency);
    }

    @Override
    public void jvmImplementation(Object notation) {
        this.jvmImplementationDependencies.getDependencies().add((Object)this.getDependencyHandler().create(notation));
    }

    @Override
    public void jvmImplementation(Object notation, Action<? super ExternalModuleDependency> action) {
        ExternalModuleDependency dependency = (ExternalModuleDependency)this.getDependencyHandler().create(notation);
        action.execute((Object)dependency);
        this.jvmImplementationDependencies.getDependencies().add((Object)dependency);
    }

    @Override
    public void nativeImplementation(Object notation) {
        if (this.isFrameworkDependency(notation)) {
            this.nativeImplementation(notation, this.requestFramework());
        } else {
            this.nativeImplementationDependencies.getDependencies().add((Object)this.getDependencyHandler().create(notation));
        }
    }

    @Override
    public void nativeImplementation(Object notation, Action<? super ExternalModuleDependency> action) {
        ExternalModuleDependency dependency = (ExternalModuleDependency)this.getDependencyHandler().create(notation);
        action.execute((Object)dependency);
        if (this.isFrameworkDependency(notation)) {
            this.requestFramework().execute((Object)dependency);
        }
        this.nativeImplementationDependencies.getDependencies().add((Object)dependency);
    }

    private boolean isFrameworkDependency(Object notation) {
        if (notation instanceof String && ((String)notation).startsWith("dev.nokee.framework:")) {
            return true;
        }
        return notation instanceof Map && ((Map)notation).get("group").equals("dev.nokee.framework");
    }

    private Action<? super ExternalModuleDependency> requestFramework() {
        return dependency -> dependency.attributes(attributes -> {
            attributes.attribute(LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE, (Object)this.getObjects().named(LibraryElements.class, "framework-bundle"));
            attributes.attribute(ArtifactSerializationTypes.ARTIFACT_SERIALIZATION_TYPES_ATTRIBUTE, (Object)"deserialized");
        });
    }

    public Configuration getApiDependencies() {
        return this.apiDependencies;
    }

    public Configuration getNativeDependencies() {
        return this.nativeImplementationDependencies;
    }

    public Configuration getJvmDependencies() {
        return this.jvmImplementationDependencies;
    }
}

