/*
 * Decompiled with CFR 0.152.
 */
package dev.mythicdrops.gradle.release;

import java.io.File;
import java.nio.file.Files;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.kohsuke.github.GHAsset;
import org.kohsuke.github.GHRelease;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitHubBuilder;

@Metadata(mv={2, 0, 0}, k=1, xi=82, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0013\u001a\u00020\u0014H\u0017R\u0014\u0010\u0004\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\fR\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\f\u00a8\u0006\u0016"}, d2={"Ldev/mythicdrops/gradle/release/MythicDropsGitHubReleaseAssetUploadTask;", "Lorg/gradle/api/DefaultTask;", "<init>", "()V", "assets", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getAssets", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "githubApiUrl", "Lorg/gradle/api/provider/Property;", "", "getGithubApiUrl", "()Lorg/gradle/api/provider/Property;", "githubToken", "getGithubToken", "releaseTag", "getReleaseTag", "repository", "getRepository", "uploadGitHubReleaseAsset", "", "Companion", "mythicdrops-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nMythicDropsGitHubReleaseAssetUploadTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MythicDropsGitHubReleaseAssetUploadTask.kt\ndev/mythicdrops/gradle/release/MythicDropsGitHubReleaseAssetUploadTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,56:1\n1855#2,2:57\n*S KotlinDebug\n*F\n+ 1 MythicDropsGitHubReleaseAssetUploadTask.kt\ndev/mythicdrops/gradle/release/MythicDropsGitHubReleaseAssetUploadTask\n*L\n49#1:57,2\n*E\n"})
public abstract class MythicDropsGitHubReleaseAssetUploadTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    @InputFiles
    @NotNull
    public abstract ConfigurableFileCollection getAssets();

    @Input
    @NotNull
    public abstract Property<String> getGithubApiUrl();

    @Input
    @NotNull
    public abstract Property<String> getGithubToken();

    @Input
    @NotNull
    public abstract Property<String> getReleaseTag();

    @Input
    @NotNull
    public abstract Property<String> getRepository();

    @TaskAction
    public void uploadGitHubReleaseAsset() {
        if (this.getAssets().isEmpty()) {
            LOG.lifecycle("Not uploading assets to GitHub as none have been configured");
            return;
        }
        GitHub github = new GitHubBuilder().withOAuthToken((String)this.getGithubToken().get()).build();
        GHRepository gHRepository = github.getRepository((String)this.getRepository().get());
        if (gHRepository == null) {
            throw new IllegalArgumentException(this.getRepository().get() + " does not exist");
        }
        GHRepository githubRepository = gHRepository;
        GHRelease gHRelease = githubRepository.getReleaseByTagName((String)this.getReleaseTag().get());
        if (gHRelease == null) {
            throw new IllegalArgumentException("Release by tag name " + this.getReleaseTag().get() + " does not exist");
        }
        GHRelease githubRelease = gHRelease;
        Iterable $this$forEach$iv = (Iterable)this.getAssets();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            String contentType = Files.probeContentType(it.toPath());
            GHAsset githubAsset = githubRelease.uploadAsset(it, contentType);
            LOG.lifecycle("Asset uploaded to GitHub release. You can download it at: " + githubAsset.getBrowserDownloadUrl());
        }
    }

    static {
        Logger logger = Logging.getLogger(MythicDropsGitHubReleaseAssetUploadTask.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=82, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ldev/mythicdrops/gradle/release/MythicDropsGitHubReleaseAssetUploadTask$Companion;", "", "<init>", "()V", "LOG", "Lorg/gradle/api/logging/Logger;", "mythicdrops-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

