/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.message.server;

import dev.miku.r2dbc.mysql.ConnectionContext;
import dev.miku.r2dbc.mysql.message.server.CompleteMessage;
import dev.miku.r2dbc.mysql.message.server.ServerStatusMessage;
import dev.miku.r2dbc.mysql.message.server.WarningMessage;
import dev.miku.r2dbc.mysql.util.AssertUtils;
import dev.miku.r2dbc.mysql.util.VarIntUtils;
import io.netty.buffer.ByteBuf;
import java.nio.charset.Charset;

public final class OkMessage
implements WarningMessage,
ServerStatusMessage,
CompleteMessage {
    private static final int MIN_SIZE = 7;
    private final long affectedRows;
    private final long lastInsertId;
    private final short serverStatuses;
    private final int warnings;
    private final String information;

    private OkMessage(long affectedRows, long lastInsertId, short serverStatuses, int warnings, String information) {
        this.affectedRows = affectedRows;
        this.lastInsertId = lastInsertId;
        this.serverStatuses = serverStatuses;
        this.warnings = warnings;
        this.information = AssertUtils.requireNonNull(information, "information must not be null");
    }

    public long getAffectedRows() {
        return this.affectedRows;
    }

    public long getLastInsertId() {
        return this.lastInsertId;
    }

    @Override
    public short getServerStatuses() {
        return this.serverStatuses;
    }

    @Override
    public int getWarnings() {
        return this.warnings;
    }

    @Override
    public boolean isDone() {
        return (this.serverStatuses & 8) == 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OkMessage)) {
            return false;
        }
        OkMessage okMessage = (OkMessage)o;
        if (this.affectedRows != okMessage.affectedRows) {
            return false;
        }
        if (this.lastInsertId != okMessage.lastInsertId) {
            return false;
        }
        if (this.serverStatuses != okMessage.serverStatuses) {
            return false;
        }
        if (this.warnings != okMessage.warnings) {
            return false;
        }
        return this.information.equals(okMessage.information);
    }

    public int hashCode() {
        int result = (int)(this.affectedRows ^ this.affectedRows >>> 32);
        result = 31 * result + (int)(this.lastInsertId ^ this.lastInsertId >>> 32);
        result = 31 * result + this.serverStatuses;
        result = 31 * result + this.warnings;
        result = 31 * result + this.information.hashCode();
        return result;
    }

    public String toString() {
        if (this.warnings != 0) {
            return String.format("OkMessage{affectedRows=%d, lastInsertId=%d, serverStatuses=%x, warnings=%d, information='%s'}", this.affectedRows, this.lastInsertId, this.serverStatuses, this.warnings, this.information);
        }
        return String.format("OkMessage{affectedRows=%d, lastInsertId=%d, serverStatuses=%x, information='%s'}", this.affectedRows, this.lastInsertId, this.serverStatuses, this.information);
    }

    static boolean isValidSize(int bytes) {
        return bytes >= 7;
    }

    static OkMessage decode(ByteBuf buf, ConnectionContext context) {
        int warnings;
        short serverStatuses;
        buf.skipBytes(1);
        int capabilities = context.getCapabilities();
        long affectedRows = VarIntUtils.readVarInt(buf);
        long lastInsertId = VarIntUtils.readVarInt(buf);
        if ((capabilities & 0x200) != 0) {
            serverStatuses = buf.readShortLE();
            warnings = buf.readUnsignedShortLE();
        } else if ((capabilities & 0x2000) != 0) {
            serverStatuses = buf.readShortLE();
            warnings = 0;
        } else {
            serverStatuses = 0;
            warnings = 0;
        }
        if (buf.isReadable()) {
            Charset charset = context.getClientCollation().getCharset();
            int sizeAfterVarInt = VarIntUtils.checkNextVarInt(buf);
            if (sizeAfterVarInt < 0) {
                return new OkMessage(affectedRows, lastInsertId, serverStatuses, warnings, buf.toString(charset));
            }
            int readerIndex = buf.readerIndex();
            long size = VarIntUtils.readVarInt(buf);
            String information = size > (long)sizeAfterVarInt ? buf.toString(readerIndex, buf.writerIndex() - readerIndex, charset) : buf.toString(buf.readerIndex(), (int)size, charset);
            return new OkMessage(affectedRows, lastInsertId, serverStatuses, warnings, information);
        }
        return new OkMessage(affectedRows, lastInsertId, serverStatuses, warnings, "");
    }
}

