/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.message.client;

import dev.miku.r2dbc.mysql.message.client.ExchangeableMessage;
import dev.miku.r2dbc.mysql.message.client.FixedSizeClientMessage;
import io.netty.buffer.ByteBuf;

public final class PreparedFetchMessage
extends FixedSizeClientMessage
implements ExchangeableMessage {
    private static final int SIZE = 9;
    private static final byte FETCH_FLAG = 28;
    private final int statementId;
    private final int fetchSize;

    public PreparedFetchMessage(int statementId, int fetchSize) {
        this.statementId = statementId;
        this.fetchSize = fetchSize;
    }

    @Override
    protected int size() {
        return 9;
    }

    @Override
    protected void writeTo(ByteBuf buf) {
        buf.writeByte(28).writeIntLE(this.statementId).writeIntLE(this.fetchSize);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PreparedFetchMessage)) {
            return false;
        }
        PreparedFetchMessage that = (PreparedFetchMessage)o;
        if (this.statementId != that.statementId) {
            return false;
        }
        return this.fetchSize == that.fetchSize;
    }

    public int hashCode() {
        int result = this.statementId;
        result = 31 * result + this.fetchSize;
        return result;
    }

    public String toString() {
        return String.format("PreparedFetchMessage{statementId=%d, fetchSize=%d}", this.statementId, Integer.toUnsignedLong(this.fetchSize));
    }
}

