/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.message.client;

import dev.miku.r2dbc.mysql.ConnectionContext;
import dev.miku.r2dbc.mysql.message.client.ExchangeableMessage;
import dev.miku.r2dbc.mysql.message.client.LargeClientMessage;
import dev.miku.r2dbc.mysql.util.AssertUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.nio.charset.Charset;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

abstract class AbstractQueryMessage
extends LargeClientMessage
implements ExchangeableMessage {
    private final byte flag;
    private final CharSequence sql;

    AbstractQueryMessage(byte flag, CharSequence sql) {
        this.flag = flag;
        this.sql = AssertUtils.requireNonNull(sql, "sql must not be null");
    }

    public CharSequence getSql() {
        return this.sql;
    }

    @Override
    protected Publisher<ByteBuf> fragments(ByteBufAllocator allocator, ConnectionContext context) {
        Charset charset = context.getClientCollation().getCharset();
        ByteBuf buf = allocator.buffer(1 + this.sql.length(), Integer.MAX_VALUE);
        try {
            buf.writeByte((int)this.flag).writeCharSequence(this.sql, charset);
            return Mono.just((Object)buf);
        }
        catch (Throwable e) {
            buf.release();
            return Mono.error((Throwable)e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractQueryMessage)) {
            return false;
        }
        AbstractQueryMessage that = (AbstractQueryMessage)o;
        if (this.flag != that.flag) {
            return false;
        }
        return this.sql.equals(that.sql);
    }

    public int hashCode() {
        int result = this.flag;
        result = 31 * result + this.sql.hashCode();
        return result;
    }
}

