/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.codec.lob;

import dev.miku.r2dbc.mysql.ServerVersion;
import dev.miku.r2dbc.mysql.codec.lob.MultiBlob;
import dev.miku.r2dbc.mysql.codec.lob.MultiClob;
import dev.miku.r2dbc.mysql.codec.lob.SingletonBlob;
import dev.miku.r2dbc.mysql.codec.lob.SingletonClob;
import io.netty.buffer.ByteBuf;
import io.netty.util.ReferenceCountUtil;
import io.r2dbc.spi.Blob;
import io.r2dbc.spi.Clob;
import java.util.List;

public final class LobUtils {
    public static Blob createBlob(ByteBuf value) {
        ByteBuf buf = value.retain();
        try {
            return new SingletonBlob(buf);
        }
        catch (Throwable e) {
            buf.release();
            throw e;
        }
    }

    public static Blob createBlob(List<ByteBuf> value) {
        int i;
        int size = value.size();
        try {
            for (i = 0; i < size; ++i) {
                value.get(i).retain();
            }
            return new MultiBlob(value);
        }
        catch (Throwable e) {
            for (int j = 0; j < i; ++j) {
                ReferenceCountUtil.safeRelease((Object)value.get(j));
            }
            throw e;
        }
    }

    public static Clob createClob(ByteBuf value, int collationId, ServerVersion version) {
        ByteBuf buf = value.retain();
        try {
            return new SingletonClob(buf, collationId, version);
        }
        catch (Throwable e) {
            buf.release();
            throw e;
        }
    }

    public static Clob createClob(List<ByteBuf> buffers, int collationId, ServerVersion version) {
        int i;
        int size = buffers.size();
        try {
            for (i = 0; i < size; ++i) {
                buffers.get(i).retain();
            }
            return new MultiClob(buffers, collationId, version);
        }
        catch (Throwable e) {
            for (int j = 0; j < i; ++j) {
                ReferenceCountUtil.safeRelease((Object)buffers.get(j));
            }
            throw e;
        }
    }

    private LobUtils() {
    }
}

