/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.codec;

import dev.miku.r2dbc.mysql.Parameter;
import dev.miku.r2dbc.mysql.ParameterWriter;
import dev.miku.r2dbc.mysql.codec.AbstractParameter;
import dev.miku.r2dbc.mysql.codec.CodecContext;
import dev.miku.r2dbc.mysql.codec.DateTimes;
import dev.miku.r2dbc.mysql.codec.FieldInformation;
import dev.miku.r2dbc.mysql.codec.LocalDateTimeCodec;
import dev.miku.r2dbc.mysql.codec.ParametrizedCodec;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.lang.reflect.ParameterizedType;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

final class ZonedDateTimeCodec
implements ParametrizedCodec<ZonedDateTime> {
    private final ByteBufAllocator allocator;

    ZonedDateTimeCodec(ByteBufAllocator allocator) {
        this.allocator = allocator;
    }

    @Override
    public ZonedDateTime decode(ByteBuf value, FieldInformation info, Class<?> target, boolean binary, CodecContext context) {
        return this.decode0(value, binary, context);
    }

    @Override
    public ChronoZonedDateTime<LocalDate> decode(ByteBuf value, FieldInformation info, ParameterizedType target, boolean binary, CodecContext context) {
        return this.decode0(value, binary, context);
    }

    @Override
    public Parameter encode(Object value, CodecContext context) {
        return new ZonedDateTimeParameter(this.allocator, (ZonedDateTime)value, context);
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof ZonedDateTime;
    }

    @Override
    public boolean canDecode(FieldInformation info, ParameterizedType target) {
        return DateTimes.canDecodeChronology(info.getType(), target, ChronoZonedDateTime.class);
    }

    @Override
    public boolean canDecode(FieldInformation info, Class<?> target) {
        return DateTimes.canDecodeDateTime(info.getType(), target, ZonedDateTime.class);
    }

    @Nullable
    private ZonedDateTime decode0(ByteBuf value, boolean binary, CodecContext context) {
        LocalDateTime origin = LocalDateTimeCodec.decodeOrigin(value, binary, context);
        return origin == null ? null : ZonedDateTime.of(origin, context.getServerZoneId());
    }

    private static final class ZonedDateTimeParameter
    extends AbstractParameter {
        private final ByteBufAllocator allocator;
        private final ZonedDateTime value;
        private final CodecContext context;

        private ZonedDateTimeParameter(ByteBufAllocator allocator, ZonedDateTime value, CodecContext context) {
            this.allocator = allocator;
            this.value = value;
            this.context = context;
        }

        public Mono<ByteBuf> publishBinary() {
            return Mono.fromSupplier(() -> LocalDateTimeCodec.encodeBinary(this.allocator, this.serverValue()));
        }

        @Override
        public Mono<Void> publishText(ParameterWriter writer) {
            return Mono.fromRunnable(() -> LocalDateTimeCodec.encodeText(writer, this.serverValue()));
        }

        @Override
        public short getType() {
            return 7;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ZonedDateTimeParameter)) {
                return false;
            }
            ZonedDateTimeParameter that = (ZonedDateTimeParameter)o;
            return this.value.equals(that.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        private LocalDateTime serverValue() {
            return this.value.withZoneSameInstant(this.context.getServerZoneId()).toLocalDateTime();
        }
    }
}

