/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.codec;

import dev.miku.r2dbc.mysql.Parameter;
import dev.miku.r2dbc.mysql.ParameterWriter;
import dev.miku.r2dbc.mysql.codec.AbstractClassedCodec;
import dev.miku.r2dbc.mysql.codec.AbstractParameter;
import dev.miku.r2dbc.mysql.codec.CodecContext;
import dev.miku.r2dbc.mysql.codec.FieldInformation;
import dev.miku.r2dbc.mysql.codec.LocalTimeCodec;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.time.Instant;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import reactor.core.publisher.Mono;

final class OffsetTimeCodec
extends AbstractClassedCodec<OffsetTime> {
    OffsetTimeCodec(ByteBufAllocator allocator) {
        super(allocator, OffsetTime.class);
    }

    @Override
    public OffsetTime decode(ByteBuf value, FieldInformation info, Class<?> target, boolean binary, CodecContext context) {
        LocalTime origin = LocalTimeCodec.decodeOrigin(binary, value);
        ZoneId zone = context.getServerZoneId();
        return OffsetTime.of(origin, zone instanceof ZoneOffset ? (ZoneOffset)zone : zone.getRules().getStandardOffset(Instant.EPOCH));
    }

    @Override
    public Parameter encode(Object value, CodecContext context) {
        return new OffsetTimeParameter(this.allocator, (OffsetTime)value, context);
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof OffsetTime;
    }

    @Override
    public boolean doCanDecode(FieldInformation info) {
        return 11 == info.getType();
    }

    private static final class OffsetTimeParameter
    extends AbstractParameter {
        private final ByteBufAllocator allocator;
        private final OffsetTime value;
        private final CodecContext context;

        private OffsetTimeParameter(ByteBufAllocator allocator, OffsetTime value, CodecContext context) {
            this.allocator = allocator;
            this.value = value;
            this.context = context;
        }

        public Mono<ByteBuf> publishBinary() {
            return Mono.fromSupplier(() -> LocalTimeCodec.encodeBinary(this.allocator, this.serverValue()));
        }

        @Override
        public Mono<Void> publishText(ParameterWriter writer) {
            return Mono.fromRunnable(() -> LocalTimeCodec.encodeTime(writer, this.serverValue()));
        }

        @Override
        public short getType() {
            return 11;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof OffsetTimeParameter)) {
                return false;
            }
            OffsetTimeParameter that = (OffsetTimeParameter)o;
            return this.value.equals(that.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        private LocalTime serverValue() {
            ZoneId zone = this.context.getServerZoneId();
            ZoneOffset offset = zone instanceof ZoneOffset ? (ZoneOffset)zone : zone.getRules().getStandardOffset(Instant.EPOCH);
            return this.value.toLocalTime().plusSeconds(offset.getTotalSeconds() - this.value.getOffset().getTotalSeconds());
        }
    }
}

