/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.authentication;

import dev.miku.r2dbc.mysql.authentication.CachingSha2FastAuthProvider;
import dev.miku.r2dbc.mysql.authentication.MySqlNativeAuthProvider;
import dev.miku.r2dbc.mysql.authentication.NoAuthProvider;
import dev.miku.r2dbc.mysql.authentication.OldAuthProvider;
import dev.miku.r2dbc.mysql.authentication.Sha256AuthProvider;
import dev.miku.r2dbc.mysql.collation.CharCollation;
import dev.miku.r2dbc.mysql.util.AssertUtils;
import io.r2dbc.spi.R2dbcPermissionDeniedException;
import reactor.util.annotation.Nullable;

public interface MySqlAuthProvider {
    public static final String CACHING_SHA2_PASSWORD = "caching_sha2_password";
    public static final String MYSQL_NATIVE_PASSWORD = "mysql_native_password";
    public static final String SHA256_PASSWORD = "sha256_password";
    public static final String MYSQL_OLD_PASSWORD = "mysql_old_password";
    public static final String NO_AUTH_PROVIDER = "";

    public static MySqlAuthProvider build(String type) {
        AssertUtils.requireNonNull(type, "type must not be null");
        switch (type) {
            case "caching_sha2_password": {
                return CachingSha2FastAuthProvider.INSTANCE;
            }
            case "mysql_native_password": {
                return MySqlNativeAuthProvider.INSTANCE;
            }
            case "sha256_password": {
                return Sha256AuthProvider.INSTANCE;
            }
            case "mysql_old_password": {
                return OldAuthProvider.INSTANCE;
            }
            case "": {
                return NoAuthProvider.INSTANCE;
            }
        }
        throw new R2dbcPermissionDeniedException(String.format("Authentication type '%s' not supported", type));
    }

    public String getType();

    public boolean isSslNecessary();

    public byte[] authentication(@Nullable CharSequence var1, @Nullable byte[] var2, CharCollation var3);

    public MySqlAuthProvider next();
}

