/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql;

import dev.miku.r2dbc.mysql.BaseHandler;
import dev.miku.r2dbc.mysql.Binding;
import dev.miku.r2dbc.mysql.ExceptionFactory;
import dev.miku.r2dbc.mysql.TextQuery;
import dev.miku.r2dbc.mysql.message.client.ClientMessage;
import dev.miku.r2dbc.mysql.message.server.ErrorMessage;
import dev.miku.r2dbc.mysql.message.server.ServerMessage;
import java.util.Iterator;
import java.util.function.Consumer;
import reactor.core.publisher.EmitterProcessor;
import reactor.core.publisher.SynchronousSink;

final class TextQueryHandler
extends BaseHandler
implements Consumer<String> {
    private final TextQuery query;
    private final Iterator<Binding> bindings;
    private String current;

    TextQueryHandler(EmitterProcessor<ClientMessage> requests, TextQuery query, Iterator<Binding> bindings) {
        super(requests);
        Binding binding = bindings.next();
        requests.onNext((Object)binding.toTextMessage(query, this));
        this.query = query;
        this.bindings = bindings;
    }

    @Override
    public void accept(String s) {
        this.current = s;
    }

    @Override
    public void accept(ServerMessage message, SynchronousSink<ServerMessage> sink) {
        if (message instanceof ErrorMessage) {
            sink.error((Throwable)ExceptionFactory.createException((ErrorMessage)message, this.current));
        } else {
            sink.next((Object)message);
        }
    }

    @Override
    protected boolean hasNext() {
        return this.bindings.hasNext();
    }

    @Override
    protected ClientMessage nextMessage() {
        return this.bindings.next().toTextMessage(this.query, this);
    }

    void close() {
        this.requests.onComplete();
        while (this.bindings.hasNext()) {
            this.bindings.next().clear();
        }
    }
}

