/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql;

import dev.miku.r2dbc.mysql.ParameterIndex;
import dev.miku.r2dbc.mysql.Query;
import dev.miku.r2dbc.mysql.util.AssertUtils;
import java.util.Map;
import java.util.Set;

final class PrepareQuery
extends Query {
    private final String sql;
    private final Map<String, ParameterIndex> nameKeyedIndex;
    private final int parameters;

    PrepareQuery(String sql, Map<String, ParameterIndex> nameKeyedIndex, int parameters) {
        AssertUtils.require(parameters > 0, "parameters must be greater than 0");
        AssertUtils.requireNonNull(nameKeyedIndex, "named parameter map must not be null");
        this.sql = sql;
        this.nameKeyedIndex = nameKeyedIndex;
        this.parameters = parameters;
    }

    @Override
    int getParameters() {
        return this.parameters;
    }

    @Override
    ParameterIndex getIndexes(String identifier) {
        ParameterIndex index = this.nameKeyedIndex.get(identifier);
        if (index == null) {
            throw new IllegalArgumentException(String.format("No such parameter with identifier '%s'", identifier));
        }
        return index;
    }

    Set<String> getParameterNames() {
        return this.nameKeyedIndex.keySet();
    }

    String getSql() {
        return this.sql;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PrepareQuery)) {
            return false;
        }
        PrepareQuery that = (PrepareQuery)o;
        if (this.parameters != that.parameters) {
            return false;
        }
        if (!this.sql.equals(that.sql)) {
            return false;
        }
        return this.nameKeyedIndex.equals(that.nameKeyedIndex);
    }

    public int hashCode() {
        int result = this.sql.hashCode();
        result = 31 * result + this.nameKeyedIndex.hashCode();
        result = 31 * result + this.parameters;
        return result;
    }

    public String toString() {
        return String.format("PrepareQuery{sql=REDACTED, parameters=%d, nameKeyedIndex=%s", this.parameters, this.nameKeyedIndex);
    }
}

