/*
 * Decompiled with CFR 0.152.
 */
package dev.mccue.guava.io;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dev.mccue.guava.base.MoreObjects;
import dev.mccue.guava.base.Preconditions;
import dev.mccue.guava.collect.Lists;
import dev.mccue.guava.io.ByteSource;
import dev.mccue.guava.io.CharSource;
import dev.mccue.guava.io.ElementTypesAreNonnullByDefault;
import dev.mccue.guava.io.LineProcessor;
import dev.mccue.guava.io.ParametricNullness;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;

@ElementTypesAreNonnullByDefault
public final class Resources {
    private Resources() {
    }

    public static ByteSource asByteSource(URL url) {
        return new UrlByteSource(url);
    }

    public static CharSource asCharSource(URL url, Charset charset) {
        return Resources.asByteSource(url).asCharSource(charset);
    }

    public static byte[] toByteArray(URL url) throws IOException {
        return Resources.asByteSource(url).read();
    }

    public static String toString(URL url, Charset charset) throws IOException {
        return Resources.asCharSource(url, charset).read();
    }

    @ParametricNullness
    @CanIgnoreReturnValue
    public static <T> T readLines(URL url, Charset charset, LineProcessor<T> callback) throws IOException {
        return Resources.asCharSource(url, charset).readLines(callback);
    }

    public static List<String> readLines(URL url, Charset charset) throws IOException {
        return Resources.readLines(url, charset, new LineProcessor<List<String>>(){
            final List<String> result = Lists.newArrayList();

            @Override
            public boolean processLine(String line) {
                this.result.add(line);
                return true;
            }

            @Override
            public List<String> getResult() {
                return this.result;
            }
        });
    }

    public static void copy(URL from, OutputStream to) throws IOException {
        Resources.asByteSource(from).copyTo(to);
    }

    @CanIgnoreReturnValue
    public static URL getResource(String resourceName) {
        ClassLoader loader = (ClassLoader)MoreObjects.firstNonNull((Object)Thread.currentThread().getContextClassLoader(), (Object)Resources.class.getClassLoader());
        URL url = loader.getResource(resourceName);
        Preconditions.checkArgument((url != null ? 1 : 0) != 0, (String)"resource %s not found.", (Object)resourceName);
        return url;
    }

    @CanIgnoreReturnValue
    public static URL getResource(Class<?> contextClass, String resourceName) {
        URL url = contextClass.getResource(resourceName);
        Preconditions.checkArgument((url != null ? 1 : 0) != 0, (String)"resource %s relative to %s not found.", (Object)resourceName, (Object)contextClass.getName());
        return url;
    }

    private static final class UrlByteSource
    extends ByteSource {
        private final URL url;

        private UrlByteSource(URL url) {
            this.url = (URL)Preconditions.checkNotNull((Object)url);
        }

        @Override
        public InputStream openStream() throws IOException {
            return this.url.openStream();
        }

        public String toString() {
            return "Resources.asByteSource(" + this.url + ")";
        }
    }
}

