/*
 * Decompiled with CFR 0.152.
 */
package dev.mccue.guava.io;

import dev.mccue.guava.base.Preconditions;
import dev.mccue.guava.io.ElementTypesAreNonnullByDefault;
import java.io.File;
import java.io.FilenameFilter;
import java.util.regex.Pattern;

@ElementTypesAreNonnullByDefault
public final class PatternFilenameFilter
implements FilenameFilter {
    private final Pattern pattern;

    public PatternFilenameFilter(String patternStr) {
        this(Pattern.compile(patternStr));
    }

    public PatternFilenameFilter(Pattern pattern) {
        this.pattern = (Pattern)Preconditions.checkNotNull((Object)pattern);
    }

    @Override
    public boolean accept(File dir, String fileName) {
        return this.pattern.matcher(fileName).matches();
    }
}

