/*
 * Decompiled with CFR 0.152.
 */
package dev.mccue.guava.io;

import dev.mccue.guava.io.ElementTypesAreNonnullByDefault;
import java.io.Flushable;
import java.io.IOException;

@ElementTypesAreNonnullByDefault
public final class Flushables {
    private static final System.Logger logger = System.getLogger(Flushables.class.getName());

    private Flushables() {
    }

    public static void flush(Flushable flushable, boolean swallowIOException) throws IOException {
        try {
            flushable.flush();
        }
        catch (IOException e) {
            if (swallowIOException) {
                logger.log(System.Logger.Level.WARNING, "IOException thrown while flushing Flushable.", (Throwable)e);
            }
            throw e;
        }
    }

    public static void flushQuietly(Flushable flushable) {
        try {
            Flushables.flush(flushable, true);
        }
        catch (IOException e) {
            logger.log(System.Logger.Level.ERROR, "IOException should not have been thrown.", (Throwable)e);
        }
    }
}

